/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityEndergrade;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class EndergradeAITargetItems<T extends ItemEntity>
extends TargetGoal {
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    protected int executionChance;
    protected boolean mustUpdate;
    protected ItemEntity targetEntity;
    private EntityEndergrade endergrade;

    public EndergradeAITargetItems(EntityEndergrade creature, boolean checkSight) {
        this(creature, checkSight, false);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public EndergradeAITargetItems(EntityEndergrade creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 10, checkSight, onlyNearby, null);
    }

    public EndergradeAITargetItems(EntityEndergrade creature, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super((MobEntity)creature, checkSight, onlyNearby);
        this.executionChance = chance;
        this.endergrade = creature;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.targetEntitySelector = new Predicate<ItemEntity>(){

            public boolean apply(@Nullable ItemEntity item) {
                ItemStack stack = item.func_92059_d();
                return !stack.func_190926_b() && EndergradeAITargetItems.this.endergrade.canTargetItem(stack);
            }
        };
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        List list;
        if (this.field_75299_d.func_184218_aH() || this.field_75299_d.func_184207_aI() && this.field_75299_d.func_184179_bs() != null) {
            return false;
        }
        if (!this.field_75299_d.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        if (!this.mustUpdate) {
            long worldTime = this.field_75299_d.field_70170_p.func_82737_E() % 10L;
            if (this.field_75299_d.func_70654_ax() >= 100 && worldTime != 0L) {
                return false;
            }
            if (this.field_75299_d.func_70681_au().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                return false;
            }
        }
        if ((list = this.field_75299_d.field_70170_p.func_175647_a(ItemEntity.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector)).isEmpty()) {
            return false;
        }
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        this.targetEntity = (ItemEntity)list.get(0);
        this.endergrade.stopWandering = true;
        this.endergrade.hasItemTarget = true;
        this.mustUpdate = false;
        return true;
    }

    protected double func_111175_f() {
        return 16.0;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        Vector3d renderCenter = new Vector3d(this.field_75299_d.func_226277_ct_() + 0.5, this.field_75299_d.func_226278_cu_() + 0.5, this.field_75299_d.func_226281_cx_() + 0.5);
        double renderRadius = 9.0;
        AxisAlignedBB aabb = new AxisAlignedBB(-renderRadius, -renderRadius, -renderRadius, renderRadius, renderRadius, renderRadius);
        return aabb.func_191194_a(renderCenter);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
        super.func_75249_e();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || this.targetEntity != null && !this.targetEntity.func_70089_S()) {
            this.func_75251_c();
        } else {
            this.field_75299_d.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
        }
        if (this.targetEntity != null && this.targetEntity.func_70089_S() && this.field_75299_d.func_70068_e((Entity)this.targetEntity) < 2.0 && this.field_75299_d.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            ItemStack duplicate = this.targetEntity.func_92059_d().func_77946_l();
            this.endergrade.bite();
            duplicate.func_190920_e(1);
            if (!this.field_75299_d.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.field_75299_d.field_70170_p.field_72995_K) {
                this.field_75299_d.func_70099_a(this.field_75299_d.func_184586_b(Hand.MAIN_HAND), 0.0f);
            }
            this.field_75299_d.func_184611_a(Hand.MAIN_HAND, duplicate);
            this.endergrade.onGetItem(this.targetEntity);
            this.targetEntity.func_92059_d().func_190918_g(1);
            this.func_75251_c();
        }
    }

    public void func_75251_c() {
        this.targetEntity = null;
        this.endergrade.hasItemTarget = false;
        this.endergrade.stopWandering = false;
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public boolean func_75253_b() {
        return this.field_75299_d.func_70605_aq().func_75640_a();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

