/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import java.util.ArrayList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.IntSliderButton;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.config.ConfigField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class SlotMetadata<T>
implements Comparable<SlotMetadata> {
    protected final Button button;
    protected final String range;
    protected final T defaultValue;
    protected final ValueType valueType;
    protected String name;
    protected String tooltip;
    protected boolean advanced;
    protected List<IReorderingProcessor> tooltipLines;
    protected List valueList;
    protected boolean master;
    protected int order;

    public SlotMetadata(Button button) {
        this(button, false);
    }

    public SlotMetadata(Button button, int order) {
        this(button, false);
        this.order = order;
    }

    public SlotMetadata(Button button, boolean advanced) {
        this(button, button.getDisplayString(), button.getUnformattedTooltip(), null, null, advanced);
    }

    public SlotMetadata(Button button, String name, String tooltip, boolean advanced) {
        this(button, name, tooltip, null, null, advanced);
    }

    public SlotMetadata(Button button, String name, String tooltip) {
        this(button, name, tooltip, null, null, false);
    }

    public SlotMetadata(Button button, String name, String tooltip, int order) {
        this(button, name, tooltip, null, null, false);
        this.order = order;
    }

    public SlotMetadata(Button button, String name, String tooltip, String range, T defaultValue, boolean advanced) {
        this.button = button;
        this.name = name;
        this.tooltip = tooltip;
        this.range = range;
        this.defaultValue = defaultValue;
        this.advanced = advanced;
        this.valueType = defaultValue == null && range == null && !advanced ? ValueType.Toolbar : (defaultValue instanceof Boolean ? ValueType.Boolean : (defaultValue instanceof Integer ? ValueType.Integer : ValueType.Set));
    }

    public boolean isMasterPropertyForCategory() {
        return this.master;
    }

    public void setMasterPropertyForCategory(boolean master) {
        this.master = master;
    }

    public Button getButton() {
        return this.button;
    }

    public String getName() {
        return this.name;
    }

    public String getRange() {
        return this.range;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public List<IReorderingProcessor> getTooltipLines() {
        return this.tooltipLines;
    }

    public boolean isMaster() {
        return this.master;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isToolbar() {
        return this.valueType == ValueType.Toolbar;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public List getValueList() {
        return this.valueList;
    }

    public void setValueList(List valueList) {
        this.valueList = valueList;
    }

    public void updateFromButton() {
        if (this.button != null) {
            this.name = this.button.getDisplayString();
            this.tooltip = this.button.getUnformattedTooltip();
            this.tooltipLines = null;
        }
    }

    public List<IReorderingProcessor> getTooltip() {
        if (this.tooltipLines == null) {
            ArrayList<IReorderingProcessor> lines = new ArrayList<IReorderingProcessor>(4);
            if (this.tooltip != null || this.range != null || this.defaultValue != null || this.advanced) {
                TextFormatting nameColor = this.isToolbar() ? TextFormatting.GREEN : (this.advanced ? TextFormatting.RED : TextFormatting.AQUA);
                String formattedName = Constants.getTranslatedTextComponent("jm.config.tooltip_format", this.name).getString();
                lines.add(IReorderingProcessor.func_242239_a((String)formattedName, (Style)Style.field_240709_b_.func_240721_b_(nameColor)));
                if (this.tooltip != null) {
                    lines.addAll(this.getWordWrappedLines(this.tooltip, Style.field_240709_b_.func_240721_b_(TextFormatting.YELLOW)));
                }
                if (this.button != null && this.button instanceof IntSliderButton) {
                    Style style = Style.field_240709_b_.func_240720_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC});
                    lines.addAll(this.getWordWrappedLines(Constants.getString("jm.config.control_arrowkeys"), style));
                }
                if (this.range != null) {
                    String formattedRange = Constants.getTranslatedTextComponent("jm.config.tooltip_format", this.range).getString();
                    lines.add(IReorderingProcessor.func_242239_a((String)formattedRange, (Style)Style.field_240709_b_.func_240721_b_(TextFormatting.WHITE)));
                }
            }
            if (!lines.isEmpty()) {
                return lines;
            }
        }
        return this.tooltipLines;
    }

    protected List<IReorderingProcessor> getWordWrappedLines(String original, Style style) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
        int max = fontRenderer.func_78260_a() ? 170 : 250;
        for (ITextProperties line : fontRenderer.func_238420_b_().func_238362_b_((ITextProperties)Constants.getStringTextComponent(original), max, style)) {
            list.add(IReorderingProcessor.func_242239_a((String)Constants.getTranslatedTextComponent("jm.config.tooltip_format", line.getString()).getString(), (Style)style));
        }
        return list;
    }

    public void resetToDefaultValue() {
        if (this.button != null) {
            if (this.button instanceof IConfigFieldHolder) {
                try {
                    Object configField = ((IConfigFieldHolder)((Object)this.button)).getConfigField();
                    if (configField != null) {
                        ((ConfigField)configField).setToDefault();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.button.refresh();
        }
    }

    public boolean hasConfigField() {
        return this.button != null && this.button instanceof IConfigFieldHolder && ((IConfigFieldHolder)((Object)this.button)).getConfigField() != null;
    }

    public PropertiesBase getProperties() {
        if (this.hasConfigField()) {
            return ((ConfigField)((IConfigFieldHolder)((Object)this.button)).getConfigField()).getOwner();
        }
        return null;
    }

    @Override
    public int compareTo(SlotMetadata other) {
        int result = Boolean.compare(this.isToolbar(), other.isToolbar());
        if (result == 0) {
            result = Integer.compare(this.order, other.order);
        }
        if (result == 0) {
            result = Boolean.compare(other.master, this.master);
        }
        if (result == 0) {
            result = this.valueType.compareTo(other.valueType);
        }
        if (result == 0) {
            result = this.name.compareTo(other.name);
        }
        return result;
    }

    public static enum ValueType {
        Boolean,
        Set,
        Integer,
        Toolbar;

    }
}

