/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.ScrollPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.ForgeHooksClient;

public class ScrollPaneScreen
extends Screen {
    private static final int MAX_DISPLAY_SIZE = 6;
    protected ScrollPane scrollPane;
    protected Removable parent;
    private int paneWidth;
    private int paneHeight;
    public boolean visible = false;
    private int paneX;
    private int paneY;
    private List<DropDownItem> items;
    protected boolean renderDecorations = true;
    protected boolean renderSolidBackground = false;

    protected ScrollPaneScreen(Removable parent, List<DropDownItem> items, int paneWidth, int paneHeight, int paneX, int paneY) {
        super((ITextComponent)Constants.getStringTextComponent(""));
        this.parent = parent;
        this.paneWidth = paneWidth;
        this.paneHeight = paneHeight;
        this.paneX = paneX;
        this.paneY = paneY;
        this.items = items;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean paneClicked = this.scrollPane.func_231044_a_(mouseX, mouseY, button);
        DropDownItem pressed = (DropDownItem)this.scrollPane.mouseClicked((int)mouseX, (int)mouseX, button);
        this.scrollPane.field_230681_r_ = false;
        boolean mouseOver = this.scrollPane.func_231047_b_(mouseX, mouseY);
        if (mouseOver) {
            this.scrollPane.func_230947_b_(mouseX, mouseY, button);
            if (pressed != null) {
                this.onClick(pressed);
                return true;
            }
        } else {
            this.func_231175_as__();
            return false;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        if (this.scrollPane != null) {
            this.scrollPane.setDimensions(this.paneWidth - 6, this.paneHeight, 0, 0, this.paneX + 2, this.paneY);
            this.scrollPane.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
            if (this.visible && this.scrollPane.func_231047_b_(mouseX, mouseY)) {
                this.renderTooltip(mStack, mouseX, mouseY);
            }
            super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        }
    }

    private void renderTooltip(MatrixStack mStack, int mouseX, int mouseY) {
        Button button = this.scrollPane.getButton(mouseX, mouseY);
        if (button != null) {
            super.func_238654_b_(mStack, button.getTooltip(), mouseX, mouseY);
        }
    }

    public void func_238651_a_(MatrixStack pMatrixStack, int pVOffset) {
    }

    public void setRenderSolidBackground(boolean renderSolidBackground) {
        this.renderSolidBackground = renderSolidBackground;
    }

    public boolean mouseOverPane(double x, double y) {
        return this.scrollPane.func_231047_b_(x, y);
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        if (this.scrollPane.func_231047_b_(x, y)) {
            return this.scrollPane.func_231043_a_(x, y, scroll);
        }
        return super.func_231043_a_(x, y, scroll);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.scrollPane.func_231048_c_(mouseX, mouseY, mouseButton);
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.scrollPane.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.scrollPane.func_212927_b(mouseX, mouseY);
        super.func_212927_b(mouseX, mouseY);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        this.scrollPane.func_223281_a_(keyCode, scanCode, modifiers);
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public void setPaneWidth(int paneWidth) {
        this.paneWidth = paneWidth;
    }

    public void setPaneHeight(int paneHeight) {
        this.paneHeight = paneHeight;
    }

    public int getPaneWidth() {
        if (this.scrollPane != null) {
            return this.scrollPane.getWidth();
        }
        return this.paneWidth;
    }

    public int getPaneHeight() {
        return this.paneHeight;
    }

    public void setPaneX(int paneX) {
        this.paneX = paneX;
    }

    public void setPaneY(int paneY) {
        this.paneY = paneY;
    }

    public int getPaneX() {
        return this.paneX;
    }

    public int getPaneY() {
        return this.paneY;
    }

    public void setParent(Removable removable) {
        this.parent = removable;
    }

    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void setItems(List<DropDownItem> items) {
        this.items = items;
    }

    public void display() {
        this.scrollPane = new ScrollPane(null, Minecraft.func_71410_x(), 0, 0, this.items, this.items.get(0).func_238483_d_(), 2);
        this.scrollPane.setDrawPartialScrollable(false);
        this.scrollPane.func_230943_a_(false);
        this.scrollPane.setRenderDecorations(this.renderDecorations);
        this.scrollPane.setRenderSolidBackground(this.renderSolidBackground);
        this.visible = true;
        ForgeHooksClient.pushGuiLayer((Minecraft)Minecraft.func_71410_x(), (Screen)this);
    }

    public void onClick(DropDownItem pressed) {
        this.func_231175_as__();
    }

    public void func_231175_as__() {
        this.visible = false;
        ForgeHooksClient.popGuiLayer((Minecraft)Minecraft.func_71410_x());
        this.parent.onRemove();
    }

    public void setRenderDecorations(boolean renderDecorations) {
        this.renderDecorations = renderDecorations;
    }
}

