/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Bridge_Stairs
extends HorizontalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.func_177709_a((String)"connection", ConnectionStatus.class);
    public static final VoxelShape N = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape E = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape S = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape W = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));

    public Bridge_Stairs(AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(CONNECTION, (Comparable)((Object)ConnectionStatus.BASE)));
    }

    private BlockState StairState(BlockState state, IWorld access, BlockPos pos) {
        BlockState northState = access.func_180495_p(pos.func_177978_c());
        BlockState eastState = access.func_180495_p(pos.func_177974_f());
        BlockState southState = access.func_180495_p(pos.func_177968_d());
        BlockState westState = access.func_180495_p(pos.func_177976_e());
        boolean north = northState.func_177230_c() == this;
        boolean east = eastState.func_177230_c() == this;
        boolean south = southState.func_177230_c() == this;
        boolean west = westState.func_177230_c() == this;
        ConnectionStatus connection = this.getConnectionStatus((Direction)state.func_177229_b((Property)FACING), north, east, south, west);
        return (BlockState)state.func_206870_a(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(Direction facing, boolean north, boolean east, boolean south, boolean west) {
        boolean isConnectedNorthSouth = north && south;
        boolean isConnectedEastWest = east && west;
        switch (facing) {
            case NORTH: {
                if (isConnectedNorthSouth) {
                    return ConnectionStatus.DOUBLE;
                }
                if (south) {
                    return ConnectionStatus.RIGHT;
                }
                if (north) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case SOUTH: {
                if (isConnectedNorthSouth) {
                    return ConnectionStatus.DOUBLE;
                }
                if (north) {
                    return ConnectionStatus.RIGHT;
                }
                if (south) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case EAST: {
                if (isConnectedEastWest) {
                    return ConnectionStatus.DOUBLE;
                }
                if (west) {
                    return ConnectionStatus.RIGHT;
                }
                if (east) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case WEST: {
                if (isConnectedEastWest) {
                    return ConnectionStatus.DOUBLE;
                }
                if (east) {
                    return ConnectionStatus.RIGHT;
                }
                if (west) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
        }
        return ConnectionStatus.BASE;
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState statetwo, IWorld access, BlockPos pos, BlockPos postwo) {
        return this.StairState(state, access, pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext contx) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return N;
            }
            case SOUTH: {
                return S;
            }
            case WEST: {
                return W;
            }
        }
        return E;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockItem blockItem;
        ItemStack itemstack = player.func_184586_b(handIn);
        if (itemstack.func_77973_b() instanceof BlockItem && (blockItem = (BlockItem)itemstack.func_77973_b()).func_179223_d() == this) {
            Direction blockFacingDirection = (Direction)state.func_177229_b((Property)FACING);
            Direction facing = player.func_174811_aO();
            BlockPos placePos = pos.func_177972_a(facing).func_177984_a();
            if (level.func_180495_p(placePos).func_196958_f()) {
                level.func_180501_a(placePos, (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)blockFacingDirection), 3);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext contx) {
        BlockPos pos = contx.func_195995_a().func_177977_b();
        World world = contx.func_195991_k();
        BlockState stateBelow = world.func_180495_p(pos);
        if (stateBelow.func_177230_c() instanceof Bridge_Stairs) {
            return null;
        }
        return (BlockState)this.StairState(super.func_196258_a(contx), (IWorld)contx.func_195991_k(), contx.func_195995_a()).func_206870_a((Property)FACING, (Comparable)contx.func_195992_f().func_176746_e());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, CONNECTION});
    }

    public static enum ConnectionStatus implements IStringSerializable
    {
        BASE("base"),
        DOUBLE("double"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

