/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import com.mcwbridges.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Bridge_Block_Rope
extends Block {
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.func_177709_a((String)"connection", ConnectionStatus.class);
    protected static final VoxelShape BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)4.0, (double)15.99);
    protected static final VoxelShape SIDE_0 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_90 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_180 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0));
    protected static final VoxelShape SIDE_270 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape CORNER_0 = VoxelShapes.func_197872_a((VoxelShape)SIDE_180, (VoxelShape)SIDE_90);
    protected static final VoxelShape CORNER_90 = VoxelShapes.func_197872_a((VoxelShape)SIDE_180, (VoxelShape)SIDE_270);
    protected static final VoxelShape CORNER_180 = VoxelShapes.func_197872_a((VoxelShape)SIDE_270, (VoxelShape)SIDE_0);
    protected static final VoxelShape CORNER_270 = VoxelShapes.func_197872_a((VoxelShape)SIDE_0, (VoxelShape)SIDE_90);
    protected static final VoxelShape MIDDLE_90 = VoxelShapes.func_197872_a((VoxelShape)SIDE_0, (VoxelShape)SIDE_180);
    protected static final VoxelShape MIDDLE_0 = VoxelShapes.func_197872_a((VoxelShape)SIDE_90, (VoxelShape)SIDE_270);
    protected static final VoxelShape BASE_COLLISION = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)3.0, (double)15.99);
    protected static final VoxelShape COLLISION_SIDE_0 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_90 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_180 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)1.0));
    protected static final VoxelShape COLLISION_SIDE_270 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_CORNER_0 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_CORNER_90 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_270);
    protected static final VoxelShape COLLISION_CORNER_180 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_270, (VoxelShape)COLLISION_SIDE_0);
    protected static final VoxelShape COLLISION_CORNER_270 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_MIDDLE_90 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_180);
    protected static final VoxelShape COLLISION_MIDDLE_0 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_90, (VoxelShape)COLLISION_SIDE_270);
    public static final DirectionProperty FACING_TD = DirectionProperty.func_196962_a((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST});

    public Bridge_Block_Rope(AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(CONNECTION, (Comparable)((Object)ConnectionStatus.BASE))).func_206870_a((Property)FACING_TD, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((ConnectionStatus)((Object)state.func_177229_b(CONNECTION))) {
            case BASE: {
                return BASE;
            }
            case CORNER_NE: {
                return CORNER_270;
            }
            case CORNER_NW: {
                return CORNER_180;
            }
            case CORNER_SE: {
                return CORNER_0;
            }
            case CORNER_SW: {
                return CORNER_90;
            }
            case END_E_LEFT: {
                return SIDE_90;
            }
            case END_E_RIGHT: {
                return SIDE_90;
            }
            case END_N_LEFT: {
                return SIDE_270;
            }
            case END_N_RIGHT: {
                return SIDE_270;
            }
            case END_S_LEFT: {
                return SIDE_0;
            }
            case END_S_RIGHT: {
                return SIDE_180;
            }
            case END_W_LEFT: {
                return SIDE_180;
            }
            case END_W_RIGHT: {
                return SIDE_0;
            }
            case MIDDLE_END_E: {
                return MIDDLE_90;
            }
            case MIDDLE_END_N: {
                return MIDDLE_0;
            }
            case MIDDLE_END_S: {
                return MIDDLE_0;
            }
            case MIDDLE_END_W: {
                return MIDDLE_90;
            }
            case MIDDLE_EW: {
                return MIDDLE_0;
            }
            case MIDDLE_NS: {
                return MIDDLE_90;
            }
            case SIDE_E: {
                return SIDE_270;
            }
            case SIDE_N: {
                return SIDE_180;
            }
            case SIDE_S: {
                return SIDE_0;
            }
            case SIDE_W: {
                return SIDE_90;
            }
            case BASE_TOGGLED: {
                return BASE;
            }
        }
        return BASE;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        Direction originalDirection = (Direction)state.func_177229_b((Property)FACING_TD);
        Direction rotatedDirection = rot.func_185831_a(originalDirection);
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.func_206870_a((Property)FACING_TD, (Comparable)rotatedDirection);
    }

    public BlockState func_185471_a(BlockState state, Mirror mir) {
        Direction originalDirection = (Direction)state.func_177229_b((Property)FACING_TD);
        Direction rotatedDirection = mir == Mirror.FRONT_BACK ? originalDirection : originalDirection.func_176734_d();
        rotatedDirection = originalDirection == Direction.NORTH || originalDirection == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
        return (BlockState)state.func_206870_a((Property)FACING_TD, (Comparable)rotatedDirection);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        switch ((ConnectionStatus)((Object)state.func_177229_b(CONNECTION))) {
            case BASE: {
                return BASE;
            }
            case CORNER_NE: {
                return COLLISION_CORNER_270;
            }
            case CORNER_NW: {
                return COLLISION_CORNER_180;
            }
            case CORNER_SE: {
                return COLLISION_CORNER_0;
            }
            case CORNER_SW: {
                return COLLISION_CORNER_90;
            }
            case END_E_LEFT: {
                return COLLISION_SIDE_90;
            }
            case END_E_RIGHT: {
                return COLLISION_SIDE_90;
            }
            case END_N_LEFT: {
                return COLLISION_SIDE_270;
            }
            case END_N_RIGHT: {
                return COLLISION_SIDE_270;
            }
            case END_S_LEFT: {
                return COLLISION_SIDE_0;
            }
            case END_S_RIGHT: {
                return COLLISION_SIDE_180;
            }
            case END_W_LEFT: {
                return COLLISION_SIDE_180;
            }
            case END_W_RIGHT: {
                return COLLISION_SIDE_0;
            }
            case MIDDLE_END_E: {
                return COLLISION_MIDDLE_90;
            }
            case MIDDLE_END_N: {
                return COLLISION_MIDDLE_0;
            }
            case MIDDLE_END_S: {
                return COLLISION_MIDDLE_0;
            }
            case MIDDLE_END_W: {
                return COLLISION_MIDDLE_90;
            }
            case MIDDLE_EW: {
                return COLLISION_MIDDLE_0;
            }
            case MIDDLE_NS: {
                return COLLISION_MIDDLE_90;
            }
            case SIDE_E: {
                return COLLISION_SIDE_270;
            }
            case SIDE_N: {
                return COLLISION_SIDE_180;
            }
            case SIDE_S: {
                return COLLISION_SIDE_0;
            }
            case SIDE_W: {
                return COLLISION_SIDE_90;
            }
            case BASE_TOGGLED: {
                return BASE_COLLISION;
            }
        }
        return BASE_COLLISION;
    }

    private BlockState StairState(BlockState state, IWorld access, BlockPos pos) {
        boolean north = access.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        boolean east = access.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        boolean south = access.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        boolean west = access.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        ConnectionStatus connection = this.getConnectionStatus(north, east, south, west);
        Direction facingDirection = (Direction)state.func_177229_b((Property)FACING_TD);
        return (BlockState)((BlockState)state.func_206870_a(CONNECTION, (Comparable)((Object)connection))).func_206870_a((Property)FACING_TD, (Comparable)facingDirection);
    }

    private ConnectionStatus getConnectionStatus(boolean north, boolean east, boolean south, boolean west) {
        if (!(north || south || east || west)) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (!north && east && !south && west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_END_S;
        }
        if (north && !east && !south && !west) {
            return ConnectionStatus.MIDDLE_END_N;
        }
        if (!north && !east && !south && west) {
            return ConnectionStatus.MIDDLE_END_W;
        }
        if (!north && east && !south && !west) {
            return ConnectionStatus.MIDDLE_END_E;
        }
        if (!north && !east && south && west) {
            return ConnectionStatus.CORNER_SW;
        }
        if (!north && east && south && !west) {
            return ConnectionStatus.CORNER_SE;
        }
        if (north && !east && !south && west) {
            return ConnectionStatus.CORNER_NW;
        }
        if (north && east && !south && !west) {
            return ConnectionStatus.CORNER_NE;
        }
        if (!north && east && south && west) {
            return ConnectionStatus.SIDE_N;
        }
        if (north && !east && south && west) {
            return ConnectionStatus.SIDE_E;
        }
        if (north && east && !south && west) {
            return ConnectionStatus.SIDE_S;
        }
        if (north && east && south && !west) {
            return ConnectionStatus.SIDE_W;
        }
        return ConnectionStatus.BASE;
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockItem blockItem;
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        ConnectionStatus connection = (ConnectionStatus)((Object)state.func_177229_b(CONNECTION));
        if (item == ItemInit.PLIERS.get() || item == Items.field_151097_aZ) {
            ConnectionStatus newConnection = ConnectionStatus.BASE;
            switch (connection) {
                case SIDE_E: 
                case SIDE_N: 
                case SIDE_S: 
                case SIDE_W: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case CORNER_SW: {
                    newConnection = ConnectionStatus.END_N_LEFT;
                    break;
                }
                case END_N_LEFT: {
                    newConnection = ConnectionStatus.END_S_RIGHT;
                    break;
                }
                case END_S_RIGHT: {
                    newConnection = ConnectionStatus.CORNER_NW;
                    break;
                }
                case CORNER_NW: {
                    newConnection = ConnectionStatus.END_S_LEFT;
                    break;
                }
                case END_S_LEFT: {
                    newConnection = ConnectionStatus.END_N_RIGHT;
                    break;
                }
                case END_N_RIGHT: {
                    newConnection = ConnectionStatus.CORNER_NE;
                    break;
                }
                case CORNER_NE: {
                    newConnection = ConnectionStatus.END_E_LEFT;
                    break;
                }
                case END_E_LEFT: {
                    newConnection = ConnectionStatus.END_W_RIGHT;
                    break;
                }
                case END_W_RIGHT: {
                    newConnection = ConnectionStatus.CORNER_SE;
                    break;
                }
                case CORNER_SE: {
                    newConnection = ConnectionStatus.END_W_LEFT;
                    break;
                }
                case END_W_LEFT: {
                    newConnection = ConnectionStatus.END_E_RIGHT;
                    break;
                }
                case END_E_RIGHT: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case BASE_TOGGLED: {
                    newConnection = ConnectionStatus.CORNER_SW;
                    break;
                }
                case MIDDLE_EW: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case MIDDLE_NS: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case BASE: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
            }
            level.func_175656_a(pos, (BlockState)state.func_206870_a(CONNECTION, (Comparable)((Object)newConnection)));
            return ActionResultType.SUCCESS;
        }
        if (itemstack.func_77973_b() instanceof BlockItem && (blockItem = (BlockItem)itemstack.func_77973_b()).func_179223_d() == this) {
            Direction facing = player.func_174811_aO();
            Direction blockFacingDirection = facing == Direction.NORTH || facing == Direction.SOUTH ? Direction.NORTH : Direction.EAST;
            BlockPos placePos = pos.func_177972_a(facing);
            if (level.func_180495_p(placePos).func_196958_f()) {
                level.func_180501_a(placePos, (BlockState)this.func_176223_P().func_206870_a((Property)FACING_TD, (Comparable)blockFacingDirection), 3);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState statetwo, boolean bool) {
        BlockState newState;
        if (state.func_235901_b_((Property)FACING_TD) && statetwo.func_235901_b_((Property)FACING_TD) && !statetwo.func_203425_a((newState = (BlockState)state.func_206870_a((Property)FACING_TD, statetwo.func_177229_b((Property)FACING_TD))).func_177230_c())) {
            level.func_180501_a(pos, this.StairState(newState, (IWorld)level, pos), 2);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CONNECTION, FACING_TD});
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState statetwo, IWorld access, BlockPos pos, BlockPos postwo) {
        ConnectionStatus connection = (ConnectionStatus)((Object)state.func_177229_b(CONNECTION));
        if (connection == ConnectionStatus.BASE_TOGGLED || connection == ConnectionStatus.END_N_LEFT || connection == ConnectionStatus.END_N_RIGHT || connection == ConnectionStatus.END_E_LEFT || connection == ConnectionStatus.END_E_RIGHT || connection == ConnectionStatus.END_S_LEFT || connection == ConnectionStatus.END_S_RIGHT || connection == ConnectionStatus.END_W_LEFT || connection == ConnectionStatus.END_W_RIGHT) {
            return state;
        }
        return (BlockState)this.StairState(state, access, pos).func_206870_a((Property)FACING_TD, state.func_177229_b((Property)FACING_TD));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext contx) {
        Direction facingDirection = contx.func_195992_f();
        if (facingDirection == Direction.WEST) {
            facingDirection = Direction.EAST;
        } else if (facingDirection == Direction.SOUTH) {
            facingDirection = Direction.NORTH;
        }
        BlockPos pos = contx.func_195995_a().func_177977_b();
        World world = contx.func_195991_k();
        BlockState stateBelow = world.func_180495_p(pos);
        if (stateBelow.func_177230_c() instanceof Bridge_Block_Rope) {
            return null;
        }
        return (BlockState)this.StairState(super.func_196258_a(contx), (IWorld)contx.func_195991_k(), contx.func_195995_a()).func_206870_a((Property)FACING_TD, (Comparable)facingDirection);
    }

    public static enum ConnectionStatus implements IStringSerializable
    {
        BASE("base"),
        MIDDLE_NS("middle_ns"),
        MIDDLE_EW("middle_ew"),
        MIDDLE_END_N("middle_end_n"),
        MIDDLE_END_E("middle_end_e"),
        MIDDLE_END_S("middle_end_s"),
        MIDDLE_END_W("middle_end_w"),
        CORNER_NE("corner_ne"),
        CORNER_NW("corner_nw"),
        CORNER_SE("corner_se"),
        CORNER_SW("corner_sw"),
        SIDE_N("side_n"),
        SIDE_E("side_e"),
        SIDE_S("side_s"),
        SIDE_W("side_w"),
        END_N_LEFT("end_n_left"),
        END_N_RIGHT("end_n_right"),
        END_E_LEFT("end_e_left"),
        END_E_RIGHT("end_e_right"),
        END_S_LEFT("end_s_left"),
        END_S_RIGHT("end_s_right"),
        END_W_LEFT("end_w_left"),
        END_W_RIGHT("end_w_right"),
        BASE_TOGGLED("base_toggled");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

