/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import com.mcwbridges.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Bridge_Block
extends Block {
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.func_177709_a((String)"connection", ConnectionStatus.class);
    protected static final VoxelShape BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)4.0, (double)15.99);
    protected static final VoxelShape SIDE_0 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_90 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0));
    protected static final VoxelShape SIDE_180 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0));
    protected static final VoxelShape SIDE_270 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape CORNER_0 = VoxelShapes.func_197872_a((VoxelShape)SIDE_180, (VoxelShape)SIDE_90);
    protected static final VoxelShape CORNER_90 = VoxelShapes.func_197872_a((VoxelShape)SIDE_180, (VoxelShape)SIDE_270);
    protected static final VoxelShape CORNER_180 = VoxelShapes.func_197872_a((VoxelShape)SIDE_270, (VoxelShape)SIDE_0);
    protected static final VoxelShape CORNER_270 = VoxelShapes.func_197872_a((VoxelShape)SIDE_0, (VoxelShape)SIDE_90);
    protected static final VoxelShape MIDDLE_90 = VoxelShapes.func_197872_a((VoxelShape)SIDE_0, (VoxelShape)SIDE_180);
    protected static final VoxelShape MIDDLE_0 = VoxelShapes.func_197872_a((VoxelShape)SIDE_90, (VoxelShape)SIDE_270);
    protected static final VoxelShape BASE_COLLISION = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.99, (double)3.0, (double)15.99);
    protected static final VoxelShape COLLISION_SIDE_0 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_90 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_SIDE_180 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)1.0));
    protected static final VoxelShape COLLISION_SIDE_270 = VoxelShapes.func_197872_a((VoxelShape)BASE, (VoxelShape)Block.func_208617_a((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)25.0, (double)16.0));
    protected static final VoxelShape COLLISION_CORNER_0 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_CORNER_90 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_180, (VoxelShape)COLLISION_SIDE_270);
    protected static final VoxelShape COLLISION_CORNER_180 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_270, (VoxelShape)COLLISION_SIDE_0);
    protected static final VoxelShape COLLISION_CORNER_270 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_90);
    protected static final VoxelShape COLLISION_MIDDLE_90 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_0, (VoxelShape)COLLISION_SIDE_180);
    protected static final VoxelShape COLLISION_MIDDLE_0 = VoxelShapes.func_197872_a((VoxelShape)COLLISION_SIDE_90, (VoxelShape)COLLISION_SIDE_270);

    public Bridge_Block(AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(CONNECTION, (Comparable)((Object)ConnectionStatus.BASE)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((ConnectionStatus)((Object)state.func_177229_b(CONNECTION))) {
            case BASE: {
                return BASE;
            }
            case CORNER_NE: {
                return CORNER_270;
            }
            case CORNER_NW: {
                return CORNER_180;
            }
            case CORNER_SE: {
                return CORNER_0;
            }
            case CORNER_SW: {
                return CORNER_90;
            }
            case END_N_TOGGLED: {
                return SIDE_180;
            }
            case END_E_TOGGLED: {
                return SIDE_270;
            }
            case END_S_TOGGLED: {
                return SIDE_0;
            }
            case END_W_TOGGLED: {
                return SIDE_90;
            }
            case MIDDLE_EW: {
                return MIDDLE_0;
            }
            case MIDDLE_NS: {
                return MIDDLE_90;
            }
            case SIDE_E: {
                return SIDE_270;
            }
            case SIDE_N: {
                return SIDE_180;
            }
            case SIDE_S: {
                return SIDE_0;
            }
            case SIDE_W: {
                return SIDE_90;
            }
            case BASE_TOGGLED: {
                return BASE;
            }
        }
        return BASE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        switch ((ConnectionStatus)((Object)state.func_177229_b(CONNECTION))) {
            case BASE: {
                return BASE;
            }
            case CORNER_NE: {
                return COLLISION_CORNER_270;
            }
            case CORNER_NW: {
                return COLLISION_CORNER_180;
            }
            case CORNER_SE: {
                return COLLISION_CORNER_0;
            }
            case CORNER_SW: {
                return COLLISION_CORNER_90;
            }
            case END_N_TOGGLED: {
                return COLLISION_SIDE_180;
            }
            case END_E_TOGGLED: {
                return COLLISION_SIDE_270;
            }
            case END_S_TOGGLED: {
                return COLLISION_SIDE_0;
            }
            case END_W_TOGGLED: {
                return COLLISION_SIDE_90;
            }
            case MIDDLE_EW: {
                return COLLISION_MIDDLE_0;
            }
            case MIDDLE_NS: {
                return COLLISION_MIDDLE_90;
            }
            case SIDE_E: {
                return COLLISION_SIDE_270;
            }
            case SIDE_N: {
                return COLLISION_SIDE_180;
            }
            case SIDE_S: {
                return COLLISION_SIDE_0;
            }
            case SIDE_W: {
                return COLLISION_SIDE_90;
            }
            case BASE_TOGGLED: {
                return BASE_COLLISION;
            }
        }
        return BASE_COLLISION;
    }

    private BlockState StairState(BlockState state, IWorld access, BlockPos pos) {
        boolean north = access.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        boolean east = access.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        boolean south = access.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        boolean west = access.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        ConnectionStatus connection = this.getConnectionStatus(north, east, south, west);
        return (BlockState)state.func_206870_a(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(boolean north, boolean east, boolean south, boolean west) {
        if (!(north || south || east || west)) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (!north && east && !south && west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && !east && south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (north && !east && !south && !west) {
            return ConnectionStatus.MIDDLE_EW;
        }
        if (!north && !east && !south && west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && east && !south && !west) {
            return ConnectionStatus.MIDDLE_NS;
        }
        if (!north && !east && south && west) {
            return ConnectionStatus.CORNER_SW;
        }
        if (!north && east && south && !west) {
            return ConnectionStatus.CORNER_SE;
        }
        if (north && !east && !south && west) {
            return ConnectionStatus.CORNER_NW;
        }
        if (north && east && !south && !west) {
            return ConnectionStatus.CORNER_NE;
        }
        if (!north && east && south && west) {
            return ConnectionStatus.SIDE_N;
        }
        if (north && !east && south && west) {
            return ConnectionStatus.SIDE_E;
        }
        if (north && east && !south && west) {
            return ConnectionStatus.SIDE_S;
        }
        if (north && east && south && !west) {
            return ConnectionStatus.SIDE_W;
        }
        return ConnectionStatus.BASE;
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Direction facing;
        BlockPos placePos;
        BlockItem blockItem;
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        ConnectionStatus connection = (ConnectionStatus)((Object)state.func_177229_b(CONNECTION));
        if (item == ItemInit.PLIERS.get() || item == Items.field_151097_aZ) {
            ConnectionStatus newConnection = ConnectionStatus.BASE;
            switch (connection) {
                case SIDE_E: 
                case SIDE_N: 
                case SIDE_S: 
                case SIDE_W: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case CORNER_SW: {
                    newConnection = ConnectionStatus.CORNER_NW;
                    break;
                }
                case CORNER_NW: {
                    newConnection = ConnectionStatus.CORNER_NE;
                    break;
                }
                case CORNER_NE: {
                    newConnection = ConnectionStatus.CORNER_SE;
                    break;
                }
                case CORNER_SE: {
                    newConnection = ConnectionStatus.END_N_TOGGLED;
                    break;
                }
                case END_N_TOGGLED: {
                    newConnection = ConnectionStatus.END_E_TOGGLED;
                    break;
                }
                case END_E_TOGGLED: {
                    newConnection = ConnectionStatus.END_S_TOGGLED;
                    break;
                }
                case END_S_TOGGLED: {
                    newConnection = ConnectionStatus.END_W_TOGGLED;
                    break;
                }
                case END_W_TOGGLED: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case BASE_TOGGLED: {
                    newConnection = ConnectionStatus.CORNER_SW;
                    break;
                }
                case MIDDLE_EW: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case MIDDLE_NS: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
                case BASE: {
                    newConnection = ConnectionStatus.BASE_TOGGLED;
                    break;
                }
            }
            level.func_175656_a(pos, (BlockState)state.func_206870_a(CONNECTION, (Comparable)((Object)newConnection)));
            return ActionResultType.SUCCESS;
        }
        if (itemstack.func_77973_b() instanceof BlockItem && (blockItem = (BlockItem)itemstack.func_77973_b()).func_179223_d() == this && level.func_180495_p(placePos = pos.func_177972_a(facing = player.func_174811_aO())).func_196958_f()) {
            level.func_180501_a(placePos, this.func_176223_P(), 3);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.func_203425_a(state.func_177230_c())) {
            level.func_180501_a(pos, this.StairState(state, (IWorld)level, pos), 2);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CONNECTION});
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState statetwo, IWorld access, BlockPos pos, BlockPos postwo) {
        ConnectionStatus connection = (ConnectionStatus)((Object)state.func_177229_b(CONNECTION));
        if (connection == ConnectionStatus.BASE_TOGGLED || connection == ConnectionStatus.END_N_TOGGLED || connection == ConnectionStatus.END_E_TOGGLED || connection == ConnectionStatus.END_S_TOGGLED || connection == ConnectionStatus.END_W_TOGGLED) {
            return state;
        }
        return this.StairState(state, access, pos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext contx) {
        BlockPos pos = contx.func_195995_a().func_177977_b();
        World world = contx.func_195991_k();
        BlockState stateBelow = world.func_180495_p(pos);
        if (stateBelow.func_177230_c() instanceof Bridge_Block) {
            return null;
        }
        return this.StairState(super.func_196258_a(contx), (IWorld)world, contx.func_195995_a());
    }

    public static enum ConnectionStatus implements IStringSerializable
    {
        BASE("base"),
        MIDDLE_NS("middle_ns"),
        MIDDLE_EW("middle_ew"),
        CORNER_NE("corner_ne"),
        CORNER_NW("corner_nw"),
        CORNER_SE("corner_se"),
        CORNER_SW("corner_sw"),
        SIDE_N("side_n"),
        SIDE_E("side_e"),
        SIDE_S("side_s"),
        SIDE_W("side_w"),
        END_N_TOGGLED("end_n_toggled"),
        END_E_TOGGLED("end_e_toggled"),
        END_S_TOGGLED("end_s_toggled"),
        END_W_TOGGLED("end_w_toggled"),
        BASE_TOGGLED("base_toggled");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

