/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.mixin;

import fr.raksrinana.fallingtree.fabric.FallingTree;
import fr.raksrinana.fallingtree.fabric.config.BreakMode;
import fr.raksrinana.fallingtree.fabric.tree.builder.TreeBuilder;
import fr.raksrinana.fallingtree.fabric.tree.builder.TreeTooBigException;
import fr.raksrinana.fallingtree.fabric.utils.CacheSpeed;
import fr.raksrinana.fallingtree.fabric.utils.FallingTreeUtils;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4970.class})
public abstract class AbstractBlockMixin {
    private static final Map<UUID, CacheSpeed> speedCache = new ConcurrentHashMap<UUID, CacheSpeed>();

    @Inject(method={"getDestroyProgress"}, at={@At(value="TAIL")}, cancellable=true)
    public void calcBlockBreakingDelta(class_2680 state, class_1657 player, class_1922 world, class_2338 pos, CallbackInfoReturnable<Float> callbackInfoReturnable) {
        CacheSpeed cacheSpeed;
        if (FallingTree.config.getTreesConfiguration().isTreeBreaking() && FallingTree.config.getTreesConfiguration().getBreakMode() == BreakMode.INSTANTANEOUS && FallingTreeUtils.isPlayerInRightState(player) && Objects.nonNull(cacheSpeed = speedCache.compute(player.method_5667(), (uuid, speed) -> {
            if (Objects.isNull(speed) || !speed.isValid(pos)) {
                speed = AbstractBlockMixin.getSpeed(player, pos, ((Float)callbackInfoReturnable.getReturnValue()).floatValue());
            }
            return speed;
        }))) {
            callbackInfoReturnable.setReturnValue((Object)Float.valueOf(cacheSpeed.getSpeed()));
        }
    }

    private static CacheSpeed getSpeed(class_1657 player, class_2338 pos, float originalSpeed) {
        double speedMultiplicand = FallingTree.config.getToolsConfiguration().getSpeedMultiplicand();
        try {
            return speedMultiplicand <= 0.0 ? null : (CacheSpeed)TreeBuilder.getTree(player.method_5770(), pos).map(tree -> new CacheSpeed(pos, originalSpeed / ((float)speedMultiplicand * (float)tree.getLogCount()))).orElse(null);
        }
        catch (TreeTooBigException e) {
            return null;
        }
    }
}

