/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric;

import fr.raksrinana.fallingtree.fabric.FallingTree;
import fr.raksrinana.fallingtree.fabric.config.BreakMode;
import fr.raksrinana.fallingtree.fabric.tree.Tree;
import fr.raksrinana.fallingtree.fabric.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.fabric.tree.breaking.InstantaneousTreeBreakingHandler;
import fr.raksrinana.fallingtree.fabric.tree.breaking.ShiftDownTreeBreakingHandler;
import fr.raksrinana.fallingtree.fabric.tree.builder.TreeBuilder;
import fr.raksrinana.fallingtree.fabric.tree.builder.TreeTooBigException;
import fr.raksrinana.fallingtree.fabric.utils.FallingTreeUtils;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;

public class BlockBreakHandler
implements PlayerBlockBreakEvents.Before {
    public boolean beforeBlockBreak(class_1937 world, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        if (FallingTree.config.getTreesConfiguration().isTreeBreaking() && !world.method_8608() && FallingTreeUtils.isPlayerInRightState(player)) {
            try {
                return TreeBuilder.getTree(world, blockPos).map(tree -> {
                    BreakMode breakMode = FallingTree.config.getTreesConfiguration().getBreakMode();
                    return BlockBreakHandler.getBreakingHandler(breakMode).breakTree(player, (Tree)tree);
                }).orElse(true);
            }
            catch (TreeTooBigException e) {
                player.method_9203((class_2561)new class_2588("chat.fallingtree.tree_too_big", new Object[]{FallingTree.config.getTreesConfiguration().getMaxSize()}), class_156.field_25140);
                return true;
            }
        }
        return true;
    }

    public static ITreeBreakingHandler getBreakingHandler(BreakMode breakMode) {
        if (breakMode == BreakMode.INSTANTANEOUS) {
            return InstantaneousTreeBreakingHandler.getInstance();
        }
        return ShiftDownTreeBreakingHandler.getInstance();
    }
}

