/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import java.io.IOException;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.IPacketServer;

public class SPacketToolMobSpawner
extends IPacketServer {
    private boolean createSpawner;
    private boolean server;
    private BlockPos pos;
    private String name = "";
    private int tab = -1;
    private CompoundNBT clone = new CompoundNBT();

    public SPacketToolMobSpawner(boolean createSpawner, BlockPos pos, String name, int tab) {
        this.server = true;
        this.createSpawner = createSpawner;
        this.pos = pos;
        this.name = name;
        this.tab = tab;
    }

    public SPacketToolMobSpawner(boolean createSpawner, BlockPos pos, CompoundNBT clone) {
        this.server = false;
        this.createSpawner = createSpawner;
        this.pos = pos;
        this.clone = clone;
    }

    public SPacketToolMobSpawner(boolean createSpawner, boolean server, BlockPos pos, String name, int tab, CompoundNBT clone) {
        this.createSpawner = createSpawner;
        this.server = server;
        this.pos = pos;
        this.name = name;
        this.tab = tab;
        this.clone = clone;
    }

    public SPacketToolMobSpawner() {
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.cloner;
    }

    @Override
    public CustomNpcsPermissions.Permission getPermission() {
        if (this.createSpawner) {
            return CustomNpcsPermissions.SPAWNER_CREATE;
        }
        return CustomNpcsPermissions.SPAWNER_MOB;
    }

    @Override
    public void handle() {
        if (this.server) {
            this.clone = ServerCloneController.Instance.getCloneData(this.player.func_195051_bN(), this.name, this.tab);
        }
        if (this.clone == null || this.clone.isEmpty()) {
            return;
        }
        if (this.createSpawner) {
            SPacketToolMobSpawner.createMobSpawner(this.pos, this.clone, (PlayerEntity)this.player);
        } else {
            Entity entity = SPacketToolMobSpawner.spawnClone(this.clone, (double)this.pos.func_177958_n() + 0.5, this.pos.func_177956_o() + 1, (double)this.pos.func_177952_p() + 0.5, this.player.field_70170_p);
            if (entity == null) {
                this.player.func_145747_a((ITextComponent)new StringTextComponent("Failed to create an entity out of your clone"), Util.field_240973_b_);
            }
        }
    }

    public static Entity spawnClone(CompoundNBT compound, double x, double y, double z, World world) {
        ServerCloneController.Instance.cleanTags(compound);
        compound.func_218657_a("Pos", (INBT)NBTTags.nbtDoubleList(x, y, z));
        Entity entity = (Entity)EntityType.func_220330_a((CompoundNBT)compound, (World)world).get();
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ais.setStartPos(npc.func_233580_cy_());
        }
        world.func_217376_c(entity);
        return entity;
    }

    public static void createMobSpawner(BlockPos pos, CompoundNBT comp, PlayerEntity player) {
        ServerCloneController.Instance.cleanTags(comp);
        if (comp.func_74779_i("id").equalsIgnoreCase("entityhorse")) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Currently you cant create horse spawner, its a minecraft bug"), Util.field_240973_b_);
            return;
        }
        player.field_70170_p.func_175656_a(pos, Blocks.field_150474_ac.func_176223_P());
        MobSpawnerTileEntity tile = (MobSpawnerTileEntity)player.field_70170_p.func_175625_s(pos);
        AbstractSpawner logic = tile.func_145881_a();
        if (!comp.func_150297_b("id", 8)) {
            comp.func_74778_a("id", "Pig");
        }
        comp.func_74783_a("StartPosNew", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        logic.func_184993_a(new WeightedSpawnerEntity(1, comp));
    }

    public void func_148837_a(PacketBuffer buf) throws IOException {
        this.createSpawner = buf.readBoolean();
        this.server = buf.readBoolean();
        this.pos = buf.func_179259_c();
        this.name = buf.func_218666_n();
        this.tab = buf.readInt();
        this.clone = buf.func_150793_b();
    }

    public void func_148840_b(PacketBuffer buf) throws IOException {
        buf.writeBoolean(this.createSpawner);
        buf.writeBoolean(this.server);
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.name);
        buf.writeInt(this.tab);
        buf.func_150786_a(this.clone);
    }
}

