/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.util.FakePlayer;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.QuestEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketQuestCompletionCheck
extends PacketServerBasic {
    private final int questId;

    public SPacketQuestCompletionCheck(int questId) {
        this.questId = questId;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return true;
    }

    public static void encode(SPacketQuestCompletionCheck msg, PacketBuffer buf) {
        buf.writeInt(msg.questId);
    }

    public static SPacketQuestCompletionCheck decode(PacketBuffer buf) {
        return new SPacketQuestCompletionCheck(buf.readInt());
    }

    @Override
    protected void handle() {
        PlayerData data = PlayerData.get((PlayerEntity)this.player);
        PlayerQuestData playerdata = data.questData;
        QuestData questdata = playerdata.activeQuests.get(this.questId);
        if (questdata == null) {
            return;
        }
        Quest quest = questdata.quest;
        if (!quest.questInterface.isCompleted((PlayerEntity)this.player)) {
            return;
        }
        QuestEvent.QuestTurnedInEvent event = new QuestEvent.QuestTurnedInEvent(data.scriptData.getPlayer(), quest);
        event.expReward = quest.rewardExp;
        ArrayList<IItemStack> list = new ArrayList<IItemStack>();
        for (ItemStack item : quest.rewardItems.items) {
            if (item.func_190926_b()) continue;
            list.add(NpcAPI.Instance().getIItemStack(item));
        }
        if (!quest.randomReward) {
            event.itemRewards = list.toArray(new IItemStack[list.size()]);
        } else if (!list.isEmpty()) {
            event.itemRewards = new IItemStack[]{(IItemStack)list.get(this.player.func_70681_au().nextInt(list.size()))};
        }
        EventHooks.onQuestTurnedIn(data.scriptData, event);
        for (IItemStack item : event.itemRewards) {
            if (item == null) continue;
            NoppesUtilServer.GivePlayerItem((Entity)this.player, (PlayerEntity)this.player, item.getMCItemStack());
        }
        quest.questInterface.handleComplete((PlayerEntity)this.player);
        if (event.expReward > 0) {
            NoppesUtilServer.playSound((LivingEntity)this.player, SoundEvents.field_187604_bf, 0.1f, 0.5f * ((this.player.field_70170_p.field_73012_v.nextFloat() - this.player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            this.player.func_195068_e(event.expReward);
        }
        quest.factionOptions.addPoints((PlayerEntity)this.player);
        if (quest.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(this.player.func_184102_h(), this.player.func_200200_C_().getString(), quest.mail);
        }
        if (!quest.command.isEmpty()) {
            FakePlayer cplayer = EntityNPCInterface.CommandPlayer;
            cplayer.func_70029_a(this.player.field_70170_p);
            cplayer.func_70107_b(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_());
            NoppesUtilServer.runCommand((Entity)cplayer, "QuestCompletion", quest.command, (PlayerEntity)this.player);
        }
        PlayerQuestController.setQuestFinished(quest, (PlayerEntity)this.player);
        if (quest.hasNewQuest()) {
            PlayerQuestController.addActiveQuest(quest.getNextQuest(), (PlayerEntity)this.player);
        }
    }
}

