/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ModelData;
import noppes.npcs.ModelPartData;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityNPCFlying;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityCustomNpc
extends EntityNPCFlying {
    public ModelData modelData = new ModelData();

    public EntityCustomNpc(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
        if (!CustomNpcs.EnableDefaultEyes) {
            this.modelData.eyes.type = (byte)-1;
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("NpcModelData")) {
            this.modelData.load(compound.func_74775_l("NpcModelData"));
        }
        super.func_70037_a(compound);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("NpcModelData", (INBT)this.modelData.save());
    }

    public boolean func_184198_c(CompoundNBT compound) {
        String s;
        boolean bo = super.func_184198_c(compound);
        if (bo && (s = this.func_70022_Q()).equals("minecraft:customnpcs.customnpc")) {
            compound.func_74778_a("id", "customnpcs:customnpc");
        }
        return bo;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isClientSide()) {
            LivingEntity entity;
            ModelPartData particles = this.modelData.getPartData(EnumParts.PARTICLES);
            if (particles != null && !this.isKilled()) {
                CustomNpcs.proxy.spawnParticle((LivingEntity)this, "ModelData", this.modelData, particles);
            }
            if ((entity = this.modelData.getEntity(this)) != null) {
                try {
                    entity.func_70071_h_();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EntityUtil.Copy((LivingEntity)this, entity);
            }
        }
        this.modelData.eyes.update(this);
    }

    public boolean func_184205_a(Entity par1Entity, boolean force) {
        boolean b = super.func_184205_a(par1Entity, force);
        this.func_213323_x_();
        return b;
    }

    public void func_213323_x_() {
        LivingEntity entity = this.modelData.getEntity(this);
        if (entity != null) {
            entity.func_213323_x_();
        }
        super.func_213323_x_();
    }

    @Override
    public EntitySize func_213305_a(Pose pos) {
        LivingEntity entity = this.modelData.getEntity(this);
        if (entity == null) {
            float height = 1.9f - this.modelData.getBodyY() + (this.modelData.getPartConfig((EnumParts)EnumParts.HEAD).scaleY - 1.0f) / 2.0f;
            if (this.baseSize.field_220316_b != height) {
                this.baseSize = new EntitySize(this.baseSize.field_220315_a, height, false);
            }
            return super.func_213305_a(pos);
        }
        EntitySize size = entity.func_213305_a(pos);
        if (entity instanceof EntityNPCInterface) {
            return size;
        }
        float width = size.field_220315_a / 5.0f * (float)this.display.getSize();
        float height = size.field_220316_b / 5.0f * (float)this.display.getSize();
        if (width < 0.1f) {
            width = 0.1f;
        }
        if (height < 0.1f) {
            height = 0.1f;
        }
        if (this.display.getHitboxState() == 1 || this.isKilled() && this.stats.hideKilledBody) {
            width = 1.0E-5f;
        }
        if ((double)(width / 2.0f) > this.field_70170_p.getMaxEntityRadius()) {
            this.field_70170_p.increaseMaxEntityRadius((double)(width / 2.0f));
        }
        return new EntitySize(width, height, false);
    }
}

