/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockData {
    public BlockPos pos;
    public BlockState state;
    public CompoundNBT tile;
    private ItemStack stack;

    public BlockData(BlockPos pos, BlockState state, CompoundNBT tile) {
        this.pos = pos;
        this.state = state;
        this.tile = tile;
    }

    public CompoundNBT getNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("BuildX", this.pos.func_177958_n());
        compound.func_74768_a("BuildY", this.pos.func_177956_o());
        compound.func_74768_a("BuildZ", this.pos.func_177952_p());
        compound.func_74778_a("Block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.state.func_177230_c()).toString());
        if (this.tile != null) {
            compound.func_218657_a("Tile", (INBT)this.tile);
        }
        return compound;
    }

    public static BlockData getData(CompoundNBT compound) {
        BlockPos pos = new BlockPos(compound.func_74762_e("BuildX"), compound.func_74762_e("BuildY"), compound.func_74762_e("BuildZ"));
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.func_74779_i("Block")));
        if (b == null) {
            return null;
        }
        CompoundNBT tile = null;
        if (compound.func_74764_b("Tile")) {
            tile = compound.func_74775_l("Tile");
        }
        return new BlockData(pos, b.func_176223_P(), tile);
    }

    public ItemStack getStack() {
        if (this.stack == null) {
            this.stack = new ItemStack((IItemProvider)this.state.func_177230_c(), 1);
        }
        return this.stack;
    }
}

