/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiData;
import noppes.npcs.util.CustomNPCsScheduler;

public class BankData {
    public HashMap<Integer, NpcMiscInventory> itemSlots = new HashMap();
    public HashMap<Integer, Boolean> upgradedSlots = new HashMap();
    public int unlockedSlots = 0;
    public int bankId = -1;

    public BankData() {
        for (int i = 0; i < 6; ++i) {
            this.itemSlots.put(i, new NpcMiscInventory(54));
            this.upgradedSlots.put(i, false);
        }
    }

    public void readNBT(CompoundNBT nbttagcompound) {
        this.bankId = nbttagcompound.func_74762_e("DataBankId");
        this.unlockedSlots = nbttagcompound.func_74762_e("UnlockedSlots");
        this.itemSlots = this.getItemSlots(nbttagcompound.func_150295_c("BankInv", 10));
        this.upgradedSlots = NBTTags.getBooleanList(nbttagcompound.func_150295_c("UpdatedSlots", 10));
    }

    private HashMap<Integer, NpcMiscInventory> getItemSlots(ListNBT tagList) {
        HashMap<Integer, NpcMiscInventory> list = new HashMap<Integer, NpcMiscInventory>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbttagcompound = tagList.func_150305_b(i);
            int slot = nbttagcompound.func_74762_e("Slot");
            NpcMiscInventory inv = new NpcMiscInventory(54);
            inv.setFromNBT(nbttagcompound.func_74775_l("BankItems"));
            list.put(slot, inv);
        }
        return list;
    }

    public void writeNBT(CompoundNBT nbttagcompound) {
        nbttagcompound.func_74768_a("DataBankId", this.bankId);
        nbttagcompound.func_74768_a("UnlockedSlots", this.unlockedSlots);
        nbttagcompound.func_218657_a("UpdatedSlots", (INBT)NBTTags.nbtBooleanList(this.upgradedSlots));
        nbttagcompound.func_218657_a("BankInv", (INBT)this.nbtItemSlots(this.itemSlots));
    }

    private ListNBT nbtItemSlots(HashMap<Integer, NpcMiscInventory> items) {
        ListNBT list = new ListNBT();
        for (int slot : items.keySet()) {
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Slot", slot);
            nbttagcompound.func_218657_a("BankItems", (INBT)items.get(slot).getToNBT());
            list.add((Object)nbttagcompound);
        }
        return list;
    }

    public boolean isUpgraded(Bank bank, int slot) {
        if (bank.isUpgraded(slot)) {
            return true;
        }
        return bank.canBeUpgraded(slot) && this.upgradedSlots.get(slot) != false;
    }

    public void openBankGui(ServerPlayerEntity player, EntityNPCInterface npc, int bankId, int slot) {
        Bank bank = BankController.getInstance().getBank(bankId);
        if (bank.getMaxSlots() <= slot) {
            return;
        }
        if (bank.startSlots > this.unlockedSlots) {
            this.unlockedSlots = bank.startSlots;
        }
        ItemStack currency = ItemStack.field_190927_a;
        if (this.unlockedSlots <= slot) {
            currency = bank.currencyInventory.func_70301_a(slot);
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankUnlock, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        } else if (this.isUpgraded(bank, slot)) {
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankLarge, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        } else if (bank.canBeUpgraded(slot)) {
            currency = bank.upgradeInventory.func_70301_a(slot);
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankUprade, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        } else {
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankSmall, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        }
        ItemStack item = currency;
        CustomNPCsScheduler.runTack(() -> {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("MaxSlots", bank.getMaxSlots());
            compound.func_74768_a("UnlockedSlots", this.unlockedSlots);
            if (item != null && !item.func_190926_b()) {
                compound.func_218657_a("Currency", (INBT)item.func_77955_b(new CompoundNBT()));
                ContainerNPCBankInterface container = this.getContainer((PlayerEntity)player);
                if (container != null) {
                    container.setCurrency(item);
                }
            }
            Packets.send(player, new PacketGuiData(compound));
        }, 300);
    }

    private ContainerNPCBankInterface getContainer(PlayerEntity player) {
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCBankInterface)) {
            return null;
        }
        return (ContainerNPCBankInterface)con;
    }
}

