/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.schematics.Blueprint;
import noppes.npcs.schematics.BlueprintUtil;
import noppes.npcs.schematics.Schematic;
import noppes.npcs.schematics.SchematicWrapper;
import noppes.npcs.schematics.SpongeSchem;
import noppes.npcs.util.ValueUtil;

public class SchematicController {
    public static SchematicController Instance = new SchematicController();
    private SchematicWrapper building = null;
    private CommandSource buildStarter = null;
    private int buildingPercentage = 0;
    public List<String> included = Arrays.asList("archery_range.schematic", "bakery.schematic", "barn.schematic", "building_site.schematic", "chapel.schematic", "church.schematic", "gate.schematic", "glassworks.schematic", "guard_Tower.schematic", "guild_house.schematic", "house.schematic", "house_small.schematic", "inn.schematic", "library.schematic", "lighthouse.schematic", "mill.schematic", "observatory.schematic", "ship.schematic", "shop.schematic", "stall.schematic", "stall2.schematic", "stall3.schematic", "tier_house1.schematic", "tier_house2.schematic", "tier_house3.schematic", "tower.schematic", "wall.schematic", "wall_corner.schematic");

    public List<String> list() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.included);
        for (File file : this.getDir().listFiles()) {
            String name = file.getName();
            if (!ValueUtil.isValidPath(name) || !name.toLowerCase().endsWith(".schematic") && !name.toLowerCase().endsWith(".schem") && !name.toLowerCase().endsWith(".blueprint")) continue;
            list.add(name);
        }
        Collections.sort(list);
        return list;
    }

    public File getDir() {
        File dir = new File(CustomNpcs.getWorldSaveDirectory(), "schematics");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    public void info(CommandSource sender) {
        if (this.building == null) {
            this.sendMessage(sender, "Nothing is being build");
        } else {
            this.sendMessage(sender, "Already building: " + this.building.schema.getName() + " - " + this.building.getPercentage() + "%");
            if (this.buildStarter != null) {
                this.sendMessage(sender, "Build started by: " + this.buildStarter.func_197019_b());
            }
        }
    }

    private void sendMessage(CommandSource sender, String message) {
        if (sender == null) {
            return;
        }
        sender.func_197030_a((ITextComponent)new StringTextComponent(message), false);
    }

    public void stop(CommandSource sender) {
        if (this.building == null || !this.building.isBuilding) {
            this.sendMessage(sender, "Not building");
        } else {
            this.sendMessage(sender, "Stopped building: " + this.building.schema.getName());
            this.building = null;
        }
    }

    public void build(SchematicWrapper schem, CommandSource sender) {
        if (this.building != null && this.building.isBuilding) {
            this.info(sender);
            return;
        }
        this.buildingPercentage = 0;
        this.building = schem;
        this.building.isBuilding = true;
        this.buildStarter = sender;
    }

    public void updateBuilding() {
        if (this.building == null) {
            return;
        }
        this.building.build();
        if (this.buildStarter != null && this.building.getPercentage() - this.buildingPercentage >= 10) {
            this.sendMessage(this.buildStarter, "Building at " + this.building.getPercentage() + "%");
            this.buildingPercentage = this.building.getPercentage();
        }
        if (!this.building.isBuilding) {
            if (this.buildStarter != null) {
                this.sendMessage(this.buildStarter, "Building finished");
            }
            this.building = null;
        }
    }

    public SchematicWrapper load(String name) {
        InputStream stream = null;
        if (this.included.contains(name)) {
            stream = MinecraftServer.class.getResourceAsStream("/data/customnpcs/schematics/" + name);
        }
        if (stream == null) {
            File file = new File(this.getDir(), name);
            if (!file.exists()) {
                return null;
            }
            try {
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        try {
            CompoundNBT compound = CompressedStreamTools.func_74796_a(stream);
            stream.close();
            if (name.toLowerCase().endsWith(".schem")) {
                SpongeSchem bp = new SpongeSchem(name);
                bp.load(compound);
                return new SchematicWrapper(bp);
            }
            if (name.toLowerCase().endsWith(".blueprint")) {
                Blueprint bp = BlueprintUtil.readBlueprintFromNBT(compound);
                bp.setName(name);
                return new SchematicWrapper(bp);
            }
            Schematic schema = new Schematic(name);
            schema.load(compound);
            return new SchematicWrapper(schema);
        }
        catch (IOException e) {
            LogWriter.except(e);
            return null;
        }
    }

    public void save(CommandSource sender, String name, BlockPos pos, short height, short width, short length) {
        if (this.included.contains(name = name.replace(" ", "_"))) {
            return;
        }
        ServerWorld level = sender.func_197023_e();
        File file = new File(this.getDir(), name + ".schem");
        SpongeSchem schema = SpongeSchem.Create((World)level, name, pos, height, width, length);
        NoppesUtilServer.NotifyOPs("Schematic " + name + " succesfully created", new Object[0]);
        try {
            CompressedStreamTools.func_74799_a((CompoundNBT)schema.getNBT(), (OutputStream)new FileOutputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

