/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import noppes.npcs.entity.EntityNPCInterface;

public class CmdSlay {
    static Map<String, Class<?>> slayMap = new LinkedHashMap();

    private static Map<String, Class<?>> getSlay(World level) {
        if (!slayMap.isEmpty()) {
            return slayMap;
        }
        slayMap.put("all", LivingEntity.class);
        slayMap.put("mobs", MonsterEntity.class);
        slayMap.put("animals", AnimalEntity.class);
        slayMap.put("items", ItemEntity.class);
        slayMap.put("xporbs", ExperienceOrbEntity.class);
        slayMap.put("npcs", EntityNPCInterface.class);
        for (ResourceLocation resource : ForgeRegistries.ENTITIES.getKeys()) {
            EntityType ent = (EntityType)ForgeRegistries.ENTITIES.getValue(resource);
            if (ent.func_220339_d() == EntityClassification.MISC) continue;
            String name = ent.func_210760_d();
            try {
                Entity e = ent.func_200721_a(level);
                e.remove(false);
                Class<?> cls = e.getClass();
                if (EntityNPCInterface.class.isAssignableFrom(cls) || !LivingEntity.class.isAssignableFrom(cls)) continue;
                slayMap.put(name.toLowerCase(), cls);
            }
            catch (Throwable throwable) {}
        }
        slayMap.remove("monster");
        slayMap.remove("mob");
        return slayMap;
    }

    public static LiteralArgumentBuilder<CommandSource> register() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"slay").requires(source -> source.func_197034_c(4))).then(Commands.func_197056_a((String)"type", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"range", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            ArrayList toDelete = new ArrayList();
            boolean deleteNPCs = false;
            String delete = StringArgumentType.getString((CommandContext)context, (String)"type");
            Class<?> cls = CmdSlay.getSlay((World)((CommandSource)context.getSource()).func_197023_e()).get(delete);
            if (cls != null) {
                toDelete.add(cls);
            }
            if (delete.equals("mobs")) {
                toDelete.add(GhastEntity.class);
                toDelete.add(EnderDragonEntity.class);
            }
            if (delete.equals("npcs")) {
                deleteNPCs = true;
            }
            int count = 0;
            int range = IntegerArgumentType.getInteger((CommandContext)context, (String)"range");
            AxisAlignedBB box = new AxisAlignedBB(((CommandSource)context.getSource()).func_197036_d(), ((CommandSource)context.getSource()).func_197036_d().func_72441_c(1.0, 1.0, 1.0)).func_72314_b((double)range, (double)range, (double)range);
            List list = ((CommandSource)context.getSource()).func_197023_e().func_217357_a(LivingEntity.class, box);
            for (Entity entity : list) {
                if (entity instanceof PlayerEntity || entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n() || entity instanceof EntityNPCInterface && !deleteNPCs || !CmdSlay.delete(entity, toDelete)) continue;
                ++count;
            }
            if (toDelete.contains(ExperienceOrbEntity.class)) {
                list = ((CommandSource)context.getSource()).func_197023_e().func_217357_a(ExperienceOrbEntity.class, box);
                for (Entity entity : list) {
                    entity.field_70128_L = true;
                    ++count;
                }
            }
            if (toDelete.contains(ItemEntity.class)) {
                list = ((CommandSource)context.getSource()).func_197023_e().func_217357_a(ItemEntity.class, box);
                for (Entity entity : list) {
                    entity.field_70128_L = true;
                    ++count;
                }
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(count + " entities deleted"), false);
            return 1;
        })));
        return command;
    }

    private static boolean delete(Entity entity, ArrayList<Class<?>> toDelete) {
        for (Class<?> delete : toDelete) {
            if (delete == AnimalEntity.class && entity instanceof HorseEntity || !delete.isAssignableFrom(entity.getClass())) continue;
            entity.field_70128_L = true;
            return true;
        }
        return false;
    }
}

