/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.shared;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.LegacyResourcePackWrapper;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.resources.VanillaPack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.packs.DelegatingResourcePack;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import noppes.npcs.mixin.DelegatingResourcePackMixin;
import noppes.npcs.mixin.LegacyResourcePackWrapperMixin;

public class AssetsFinder {
    private static List<ResourceLocation> list = new ArrayList<ResourceLocation>();
    private static String root;
    private static String type;

    public static List<ResourceLocation> find(String root, String type) {
        AssetsFinder.root = root;
        AssetsFinder.type = type;
        list.clear();
        SimpleReloadableResourceManager simplemanager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G();
        simplemanager.func_230232_b_().forEach(AssetsFinder::processResourcePack);
        URL url = VanillaPack.class.getResource("/assets/.mcassetsroot");
        if (url != null) {
            File f = AssetsFinder.decodeFile(url.getFile());
            if (f.isDirectory()) {
                AssetsFinder.checkFolder(new File(f, "assets"), url.getFile().length());
            } else {
                AssetsFinder.progressFile(f);
            }
        }
        return list;
    }

    private static File decodeFile(String url) {
        int i;
        if (url.startsWith("file:")) {
            url = url.substring(5);
        }
        if ((i = (url = url.replace('/', File.separatorChar)).indexOf(33)) > 0) {
            url = url.substring(0, i);
        }
        try {
            url = URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new File(url);
    }

    private static void processResourcePack(IResourcePack pack) {
        if (pack instanceof LegacyResourcePackWrapper) {
            pack = ((LegacyResourcePackWrapperMixin)pack).getSource();
        }
        if (pack instanceof DelegatingResourcePack) {
            DelegatingResourcePackMixin m = (DelegatingResourcePackMixin)pack;
            m.getAssetPacks().values().forEach(t -> t.forEach(AssetsFinder::processResourcePack));
        } else if (pack instanceof ResourcePack) {
            try {
                File file;
                File file2 = file = pack instanceof ModFileResourcePack ? ((ModFileResourcePack)pack).getModFile().getFilePath().toFile() : ((ResourcePack)pack).field_195771_a;
                if (file != null) {
                    if (file.isDirectory()) {
                        AssetsFinder.checkFolder(new File(file, root), file.getAbsolutePath().length());
                    } else {
                        AssetsFinder.progressFile(file);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void progressFile(File file) {
        try {
            if (file.isDirectory()) {
                int length = file.getAbsolutePath().length();
                AssetsFinder.checkFolder(file, length);
            } else {
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipentry = entries.nextElement();
                    String entryName = zipentry.getName();
                    AssetsFinder.addFile(entryName);
                }
                zip.close();
            }
        }
        catch (NoSuchFileException zip) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkFolder(File file, int length) {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            String name = f.getAbsolutePath().substring(length);
            if (!(name = name.replace("\\", "/")).startsWith("/")) {
                name = "/" + name;
            }
            if (f.isDirectory()) {
                AssetsFinder.addFile(name + "/");
                AssetsFinder.checkFolder(f, length);
                continue;
            }
            AssetsFinder.addFile(name);
        }
    }

    private static void addFile(String name) {
        int i;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (!(name.startsWith(root) && name.toLowerCase().endsWith(type) && AssetsFinder.isValidResource(name))) {
            return;
        }
        String domain = (name = name.substring(7)).substring(0, i = name.indexOf(47));
        ResourceLocation loc = new ResourceLocation(domain, name.substring(i + 1));
        if (!list.contains(loc)) {
            list.add(loc);
        }
    }

    public static boolean isValidResource(String name) {
        for (char c : name.toCharArray()) {
            if (ResourceLocation.func_195824_a((char)c)) continue;
            return false;
        }
        return true;
    }
}

