/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.ModelData;
import noppes.npcs.ModelPartData;
import noppes.npcs.entity.EntityCustomNpc;

public abstract class LayerInterface
extends LayerRenderer {
    protected LivingRenderer render;
    protected EntityCustomNpc npc;
    protected ModelData playerdata;
    public BipedModel base;
    private int color;

    public LayerInterface(LivingRenderer render) {
        super((IEntityRenderer)render);
        this.render = render;
        this.base = (BipedModel)render.func_217764_d();
    }

    public void setColor(ModelPartData data, LivingEntity entity) {
    }

    protected float red() {
        if (this.npc.field_70737_aN > 0 || this.npc.field_70725_aQ > 0) {
            return 1.0f;
        }
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    protected float green() {
        if (this.npc.field_70737_aN > 0 || this.npc.field_70725_aQ > 0) {
            return 0.0f;
        }
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    protected float blue() {
        if (this.npc.field_70737_aN > 0 || this.npc.field_70725_aQ > 0) {
            return 0.0f;
        }
        return (float)(this.color & 0xFF) / 255.0f;
    }

    protected float alpha() {
        if (this.npc.field_70737_aN > 0 || this.npc.field_70725_aQ > 0) {
            return 0.3f;
        }
        return 0.99f;
    }

    public void preRender(ModelPartData data) {
        if (this.npc.field_70737_aN > 0 || this.npc.field_70725_aQ > 0) {
            return;
        }
        this.color = data.color;
        if (this.npc.display.getTint() != 0xFFFFFF) {
            this.color = data.color != 0xFFFFFF ? this.blend(data.color, this.npc.display.getTint(), 0.5f) : this.npc.display.getTint();
        }
    }

    public ResourceLocation getResource(ModelPartData data) {
        if (data.playerTexture) {
            return this.npc.textureLocation;
        }
        return data.getResource();
    }

    public int blend(int color1, int color2, float ratio) {
        if (ratio >= 1.0f) {
            return color2;
        }
        if (ratio <= 0.0f) {
            return color1;
        }
        int aR = (color1 & 0xFF0000) >> 16;
        int aG = (color1 & 0xFF00) >> 8;
        int aB = color1 & 0xFF;
        int bR = (color2 & 0xFF0000) >> 16;
        int bG = (color2 & 0xFF00) >> 8;
        int bB = color2 & 0xFF;
        int R = (int)((float)aR + (float)(bR - aR) * ratio);
        int G = (int)((float)aG + (float)(bG - aG) * ratio);
        int B = (int)((float)aB + (float)(bB - aB) * ratio);
        return R << 16 | G << 8 | B;
    }

    public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Entity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.npc = (EntityCustomNpc)entity;
        if (this.npc.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        this.playerdata = this.npc.modelData;
        this.base = (BipedModel)this.render.func_217764_d();
        this.rotate(matrixStackIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        matrixStackIn.func_227860_a_();
        if (entity.func_82150_aj()) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.alphaFunc((int)516, (float)0.003921569f);
        }
        if (this.npc.field_70737_aN > 0 || this.npc.field_70725_aQ > 0) {
            RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        }
        if (this.npc.func_213453_ef()) {
            // empty if block
        }
        RenderSystem.enableRescaleNormal();
        this.render(matrixStackIn, bufferIn, packedLightIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        RenderSystem.disableRescaleNormal();
        if (entity.func_82150_aj()) {
            RenderSystem.disableBlend();
            RenderSystem.alphaFunc((int)516, (float)0.1f);
            RenderSystem.depthMask((boolean)true);
        }
        matrixStackIn.func_227865_b_();
    }

    public void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public abstract void render(MatrixStack var1, IRenderTypeBuffer var2, int var3, float var4, float var5, float var6, float var7, float var8, float var9);

    public abstract void rotate(MatrixStack var1, float var2, float var3, float var4, float var5, float var6, float var7);
}

