/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.client.gui.util.ITextfieldListener;

public class GuiNpcTextField
extends TextFieldWidget {
    public boolean enabled = true;
    public boolean inMenu = true;
    public boolean numbersOnly = false;
    public ITextfieldListener listener;
    public int id;
    public int min = 0;
    public int max = Integer.MAX_VALUE;
    public int def = 0;
    private static GuiNpcTextField activeTextfield = null;
    private final int[] allowedSpecialChars = new int[]{14, 211, 203, 205};

    public GuiNpcTextField(int id, Screen parent, int i, int j, int k, int l, String s) {
        this(id, parent, i, j, k, l, (ITextComponent)new TranslationTextComponent(s != null ? s : ""));
    }

    public GuiNpcTextField(int id, Screen parent, int i, int j, int k, int l, ITextComponent s) {
        super(Minecraft.func_71410_x().field_71466_p, i, j, k, l, s);
        this.func_146203_f(500);
        if (!s.getString().isEmpty()) {
            this.func_146180_a(s.getString());
        }
        this.id = id;
        if (parent instanceof ITextfieldListener) {
            this.listener = (ITextfieldListener)parent;
        }
    }

    public static boolean isActive() {
        return activeTextfield != null;
    }

    public static GuiNpcTextField getActive() {
        return activeTextfield;
    }

    private boolean charAllowed(char c, int i) {
        if (!this.numbersOnly || Character.isDigit(c)) {
            return true;
        }
        for (int j : this.allowedSpecialChars) {
            if (j != i) continue;
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char c, int i) {
        if (!this.charAllowed(c, i)) {
            return false;
        }
        return super.func_231042_a_(c, i);
    }

    public boolean isEmpty() {
        return this.func_146179_b().trim().length() == 0;
    }

    public int getInteger() {
        return Integer.parseInt(this.func_146179_b());
    }

    public boolean isInteger() {
        try {
            Integer.parseInt(this.func_146179_b());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean func_231044_a_(double i, double j, int k) {
        boolean wasFocused = this.func_230999_j_();
        boolean clicked = super.func_231044_a_(i, j, k);
        if (!wasFocused && this.func_230999_j_()) {
            GuiNpcTextField.unfocus();
            activeTextfield = this;
        }
        if (wasFocused && !this.func_230999_j_()) {
            this.unFocused();
        }
        return clicked;
    }

    public void unFocused() {
        if (this.numbersOnly) {
            if (this.isEmpty() || !this.isInteger()) {
                this.func_146180_a(this.def + "");
            } else if (this.getInteger() < this.min) {
                this.func_146180_a(this.min + "");
            } else if (this.getInteger() > this.max) {
                this.func_146180_a(this.max + "");
            }
        }
        if (this.listener != null) {
            this.listener.unFocused(this);
        }
        this.func_146195_b(false);
        if (this == activeTextfield) {
            activeTextfield = null;
        }
    }

    public void func_230431_b_(MatrixStack matrixStack, int x, int y, float f) {
        if (this.enabled) {
            super.func_230431_b_(matrixStack, y, x, f);
        }
    }

    public void setMinMaxDefault(int i, int j, int k) {
        this.min = i;
        this.max = j;
        this.def = k;
    }

    public static void unfocus() {
        GuiNpcTextField field = activeTextfield;
        activeTextfield = null;
        if (field != null) {
            field.unFocused();
        }
    }

    public GuiNpcTextField setNumbersOnly() {
        this.numbersOnly = true;
        return this;
    }
}

