/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabQuests;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.gui.util.GuiButtonNextPage;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.client.gui.util.ITopButtonListener;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.util.NaturalOrderComparator;

public class GuiQuestLog
extends GuiNPCInterface
implements ITopButtonListener,
ICustomScrollListener {
    private final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/standardbg.png");
    public HashMap<String, List<Quest>> activeQuests = new HashMap();
    private HashMap<String, Quest> categoryQuests = new HashMap();
    public Quest selectedQuest = null;
    public ITextComponent selectedCategory = StringTextComponent.field_240750_d_;
    private PlayerEntity player;
    private GuiCustomScroll scroll;
    private HashMap<Integer, GuiMenuSideButton> sideButtons = new HashMap();
    private boolean noQuests = false;
    private final int maxLines = 10;
    private int currentPage = 0;
    private int maxPages = 1;
    TextBlockClient textblock = null;
    private Minecraft mc = Minecraft.func_71410_x();

    public GuiQuestLog(PlayerEntity player) {
        this.player = player;
        this.imageWidth = 280;
        this.imageHeight = 180;
        this.drawDefaultBackground = false;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        for (Quest quest : PlayerQuestController.getActiveQuests(this.player)) {
            String category = quest.category.title;
            if (!this.activeQuests.containsKey(category)) {
                this.activeQuests.put(category, new ArrayList());
            }
            List<Quest> list = this.activeQuests.get(category);
            list.add(quest);
        }
        this.sideButtons.clear();
        this.guiTop += 10;
        TabRegistry.updateTabValues(this.guiLeft, this.guiTop, InventoryTabQuests.class);
        TabRegistry.addTabsToList(button -> this.func_230480_a_((Widget)button));
        this.noQuests = false;
        if (this.activeQuests.isEmpty()) {
            this.noQuests = true;
            return;
        }
        ArrayList<String> categories = new ArrayList<String>();
        categories.addAll(this.activeQuests.keySet());
        Collections.sort(categories, new NaturalOrderComparator());
        int i = 0;
        for (String category : categories) {
            if (this.selectedCategory == StringTextComponent.field_240750_d_) {
                this.selectedCategory = new TranslationTextComponent(category);
            }
            this.sideButtons.put(i, new GuiMenuSideButton(this, i, this.guiLeft - 69, this.guiTop + 2 + i * 21, 70, 22, category));
            ++i;
        }
        this.sideButtons.get((Object)Integer.valueOf((int)categories.indexOf((Object)this.selectedCategory.getString()))).field_230693_o_ = true;
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
        }
        HashMap<String, Quest> categoryQuests = new HashMap<String, Quest>();
        for (Quest q : this.activeQuests.get(this.selectedCategory.getString())) {
            categoryQuests.put(q.title, q);
        }
        this.categoryQuests = categoryQuests;
        this.scroll.setList(new ArrayList<String>(categoryQuests.keySet()));
        this.scroll.func_231149_a_(134, 174);
        this.scroll.guiLeft = this.guiLeft + 5;
        this.scroll.guiTop = this.guiTop + 15;
        this.addScroll(this.scroll);
        this.addButton(new GuiButtonNextPage((IGuiInterface)this, 1, this.guiLeft + 286, this.guiTop + 114, true));
        this.addButton(new GuiButtonNextPage((IGuiInterface)this, 2, this.guiLeft + 144, this.guiTop + 114, false));
        this.getButton((int)1).field_230694_p_ = this.selectedQuest != null && this.currentPage < this.maxPages - 1;
        this.getButton((int)2).field_230694_p_ = this.selectedQuest != null && this.currentPage > 0;
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        if (!(guibutton instanceof GuiButtonNextPage)) {
            return;
        }
        if (guibutton.id == 1) {
            ++this.currentPage;
            this.func_231160_c_();
        }
        if (guibutton.id == 2) {
            --this.currentPage;
            this.func_231160_c_();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.scroll != null) {
            this.scroll.visible = !this.noQuests;
        }
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(this.resource);
        this.func_238474_b_(matrixStack, this.guiLeft, this.guiTop, 0, 0, 252, 195);
        this.func_238474_b_(matrixStack, this.guiLeft + 252, this.guiTop, 188, 0, 67, 195);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.noQuests) {
            this.mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("quest.noquests"), (float)(this.guiLeft + 84), (float)(this.guiTop + 80), CustomNpcResourceListener.DefaultTextColor);
            return;
        }
        for (GuiMenuSideButton button : this.sideButtons.values().toArray(new GuiMenuSideButton[this.sideButtons.size()])) {
            button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.mc.field_71466_p.func_243248_b(matrixStack, this.selectedCategory, (float)(this.guiLeft + 5), (float)(this.guiTop + 5), CustomNpcResourceListener.DefaultTextColor);
        if (this.selectedQuest == null) {
            return;
        }
        this.drawProgress(matrixStack);
        this.drawQuestText(matrixStack);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(this.guiLeft + 148), (double)this.guiTop, 0.0);
        matrixStack.func_227862_a_(1.24f, 1.24f, 1.24f);
        TranslationTextComponent title = new TranslationTextComponent(this.selectedQuest.title);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)title, (float)((130 - this.field_230712_o_.func_238414_a_((ITextProperties)title)) / 2), 4.0f, CustomNpcResourceListener.DefaultTextColor);
        matrixStack.func_227865_b_();
        this.func_238465_a_(matrixStack, this.guiLeft + 142, this.guiLeft + 312, this.guiTop + 17, -16777216 + CustomNpcResourceListener.DefaultTextColor);
    }

    private void drawQuestText(MatrixStack matrixStack) {
        if (this.textblock == null) {
            return;
        }
        int yoffset = this.guiTop + 5;
        for (int i = 0; i < 10; ++i) {
            int index = i + this.currentPage * 10;
            if (index >= this.textblock.lines.size()) continue;
            ITextComponent text = (ITextComponent)this.textblock.lines.get(index);
            float f = this.guiLeft + 142;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_243248_b(matrixStack, text, f, (float)(this.guiTop + 20 + i * 9), CustomNpcResourceListener.DefaultTextColor);
        }
    }

    private void drawProgress(MatrixStack matrixStack) {
        IFormattableTextComponent title = new TranslationTextComponent("quest.objectives").func_240702_b_(":");
        this.mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)title, (float)(this.guiLeft + 142), (float)(this.guiTop + 130), CustomNpcResourceListener.DefaultTextColor);
        this.func_238465_a_(matrixStack, this.guiLeft + 142, this.guiLeft + 312, this.guiTop + 140, -16777216 + CustomNpcResourceListener.DefaultTextColor);
        int yoffset = this.guiTop + 144;
        for (IQuestObjective objective : this.selectedQuest.questInterface.getObjectives(this.player)) {
            this.mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent("- ").func_230529_a_(objective.getMCText()), (float)(this.guiLeft + 142), (float)yoffset, CustomNpcResourceListener.DefaultTextColor);
            yoffset += 10;
        }
        this.func_238465_a_(matrixStack, this.guiLeft + 142, this.guiLeft + 312, this.guiTop + 178, -16777216 + CustomNpcResourceListener.DefaultTextColor);
        String complete = this.selectedQuest.getNpcName();
        if (complete != null && !complete.isEmpty()) {
            this.mc.field_71466_p.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("quest.completewith", new Object[]{complete}), (float)(this.guiLeft + 142), (float)(this.guiTop + 182), CustomNpcResourceListener.DefaultTextColor);
        }
    }

    @Override
    public boolean func_231044_a_(double i, double j, int k) {
        super.func_231044_a_(i, j, k);
        if (k == 0) {
            if (this.scroll != null) {
                this.scroll.func_231044_a_(i, j, k);
            }
            for (GuiMenuSideButton button : new ArrayList<GuiMenuSideButton>(this.sideButtons.values())) {
                if (!button.func_231044_a_(i, j, k)) continue;
                this.sideButtonPressed(button);
                return true;
            }
        }
        return false;
    }

    private void sideButtonPressed(GuiMenuSideButton button) {
        if (button.field_230693_o_) {
            return;
        }
        NoppesUtil.clickSound();
        this.selectedCategory = button.func_230458_i_();
        this.selectedQuest = null;
        this.func_231160_c_();
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll scroll) {
        if (!scroll.hasSelected()) {
            return;
        }
        this.selectedQuest = this.categoryQuests.get(scroll.getSelected());
        this.textblock = new TextBlockClient(this.selectedQuest.getLogText(), 172, true, this.player);
        if (this.textblock.lines.size() > 10) {
            this.maxPages = MathHelper.func_76123_f((float)(1.0f * (float)this.textblock.lines.size() / 10.0f));
        }
        this.currentPage = 0;
        this.func_231160_c_();
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
    }
}

