/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.fonts.TextInputUtil;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiButtonNextPage;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiClose;
import noppes.npcs.client.gui.util.IGuiError;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketPlayerMailDelete;
import noppes.npcs.packets.server.SPacketPlayerMailSend;

@OnlyIn(value=Dist.CLIENT)
public class GuiMailmanWrite
extends GuiContainerNPCInterface<ContainerMail>
implements ITextfieldListener,
IGuiError,
IGuiClose {
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private static final ResourceLocation bookWidgets = new ResourceLocation("textures/gui/widgets.png");
    private static final ResourceLocation bookInventory = new ResourceLocation("textures/gui/container/inventory.png");
    private final TextInputUtil pageEdit = new TextInputUtil(this::getText, this::setText, this::getClipboard, this::setClipboard, p_238774_1_ -> p_238774_1_.length() < 1024 && this.field_230712_o_.func_78267_b(p_238774_1_, 114) <= 128);
    private int updateCount;
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    private int bookTotalPages = 1;
    private int currPage;
    private ListNBT bookPages;
    private GuiButtonNextPage buttonNextPage;
    private GuiButtonNextPage buttonPreviousPage;
    private final boolean canEdit;
    private final boolean canSend;
    private boolean hasSend = false;
    public static Screen parent;
    public static PlayerMail mail;
    private Minecraft mc = Minecraft.func_71410_x();
    private String username = "";
    private GuiNpcLabel error;

    public GuiMailmanWrite(ContainerMail container, PlayerInventory inv, ITextComponent titleIn) {
        super(null, container, inv, titleIn);
        this.field_230704_d_ = "";
        this.canEdit = container.canEdit;
        this.canSend = container.canSend;
        if (GuiMailmanWrite.mail.message.func_74764_b("pages")) {
            this.bookPages = GuiMailmanWrite.mail.message.func_150295_c("pages", 8);
        }
        if (this.bookPages != null) {
            this.bookPages = this.bookPages.func_74737_b();
            this.bookTotalPages = this.bookPages.size();
            if (this.bookTotalPages < 1) {
                this.bookTotalPages = 1;
            }
        } else {
            this.bookPages = new ListNBT();
            this.bookPages.add((Object)StringNBT.func_229705_a_((String)""));
            this.bookTotalPages = 1;
        }
        this.field_146999_f = 360;
        this.field_147000_g = 260;
        this.drawDefaultBackground = false;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.updateCount;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        if (this.canEdit && !this.canSend) {
            this.addLabel(new GuiNpcLabel(0, "mailbox.sender", this.guiLeft + 170, this.guiTop + 32, 0));
        } else {
            this.addLabel(new GuiNpcLabel(0, "mailbox.username", this.guiLeft + 170, this.guiTop + 32, 0));
        }
        if (this.canEdit && !this.canSend) {
            this.addTextField(new GuiNpcTextField(2, (Screen)this, this.guiLeft + 170, this.guiTop + 42, 114, 20, GuiMailmanWrite.mail.sender));
        } else if (this.canEdit) {
            this.addTextField(new GuiNpcTextField(0, (Screen)this, this.guiLeft + 170, this.guiTop + 42, 114, 20, this.username));
        } else {
            this.addLabel(new GuiNpcLabel(10, GuiMailmanWrite.mail.sender, this.guiLeft + 170, this.guiTop + 42, 0));
        }
        this.addLabel(new GuiNpcLabel(1, "mailbox.subject", this.guiLeft + 170, this.guiTop + 72, 0));
        if (this.canEdit) {
            this.addTextField(new GuiNpcTextField(1, (Screen)this, this.guiLeft + 170, this.guiTop + 82, 114, 20, GuiMailmanWrite.mail.subject));
        } else {
            this.addLabel(new GuiNpcLabel(11, GuiMailmanWrite.mail.subject, this.guiLeft + 170, this.guiTop + 82, 0));
        }
        this.error = new GuiNpcLabel(2, "", this.guiLeft + 170, this.guiTop + 114, 0xFF0000);
        this.addLabel(this.error);
        if (this.canEdit && !this.canSend) {
            this.addButton(new GuiNpcButton(this, 0, this.guiLeft + 200, this.guiTop + 171, 60, 20, "gui.done"));
        } else if (this.canEdit) {
            this.addButton(new GuiNpcButton(this, 0, this.guiLeft + 200, this.guiTop + 171, 60, 20, "mailbox.send"));
        }
        if (!this.canEdit && !this.canSend) {
            this.addButton(new GuiNpcButton(this, 4, this.guiLeft + 200, this.guiTop + 171, 60, 20, "selectWorld.deleteButton"));
        }
        if (!this.canEdit || this.canSend) {
            this.addButton(new GuiNpcButton(this, 3, this.guiLeft + 200, this.guiTop + 194, 60, 20, "gui.cancel"));
        }
        this.buttonNextPage = new GuiButtonNextPage((IGuiInterface)this, 1, this.guiLeft + 120, this.guiTop + 156, true);
        this.addButton(this.buttonNextPage);
        this.buttonPreviousPage = new GuiButtonNextPage((IGuiInterface)this, 2, this.guiLeft + 38, this.guiTop + 156, false);
        this.addButton(this.buttonPreviousPage);
        this.updateButtons();
    }

    @Override
    public void func_231175_as__() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    private void updateButtons() {
        this.buttonNextPage.field_230694_p_ = this.currPage < this.bookTotalPages - 1 || this.canEdit;
        this.buttonPreviousPage.field_230694_p_ = this.currPage > 0;
    }

    @Override
    public void buttonEvent(GuiNpcButton par1GuiButton) {
        if (par1GuiButton.field_230693_o_) {
            int id = par1GuiButton.id;
            if (id == 0) {
                GuiMailmanWrite.mail.message.func_218657_a("pages", (INBT)this.bookPages);
                if (this.canSend) {
                    if (!this.hasSend) {
                        this.hasSend = true;
                        Packets.sendServer(new SPacketPlayerMailSend(this.username, mail.writeNBT()));
                    }
                } else {
                    this.close();
                }
            }
            if (id == 3) {
                this.close();
            }
            if (id == 4) {
                ConfirmScreen guiyesno = new ConfirmScreen(flag -> {
                    if (flag) {
                        Packets.sendServer(new SPacketPlayerMailDelete(GuiMailmanWrite.mail.time, GuiMailmanWrite.mail.sender));
                        this.close();
                    } else {
                        NoppesUtil.openGUI((PlayerEntity)this.player, this);
                    }
                }, (ITextComponent)new TranslationTextComponent(""), (ITextComponent)new TranslationTextComponent(I18n.func_135052_a((String)"gui.deleteMessage", (Object[])new Object[0])));
                this.setScreen((Screen)guiyesno);
            } else if (id == 1) {
                if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                } else if (this.canEdit) {
                    this.addNewPage();
                    if (this.currPage < this.bookTotalPages - 1) {
                        ++this.currPage;
                    }
                }
            } else if (id == 2 && this.currPage > 0) {
                --this.currPage;
            }
            this.updateButtons();
        }
    }

    private void addNewPage() {
        if (this.bookPages != null && this.bookPages.size() < 50) {
            this.bookPages.add((Object)StringNBT.func_229705_a_((String)""));
            ++this.bookTotalPages;
        }
    }

    @Override
    public boolean func_231042_a_(char par1, int limbSwingAmount) {
        if (!GuiNpcTextField.isActive() && this.canEdit) {
            if (SharedConstants.func_71566_a((char)par1)) {
                this.pageEdit.func_216892_a(Character.toString(par1));
                return true;
            }
        } else {
            super.func_231042_a_(par1, limbSwingAmount);
        }
        return true;
    }

    @Override
    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_)) {
            return true;
        }
        boolean flag = this.bookKeyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
        return flag;
    }

    private boolean bookKeyPressed(int p_214230_1_, int p_214230_2_, int p_214230_3_) {
        if (Screen.func_231170_j_((int)p_214230_1_)) {
            this.pageEdit.func_238585_d_();
            return true;
        }
        if (Screen.func_231169_i_((int)p_214230_1_)) {
            this.pageEdit.func_238580_c_();
            return true;
        }
        if (Screen.func_231168_h_((int)p_214230_1_)) {
            this.pageEdit.func_238574_b_();
            return true;
        }
        if (Screen.func_231166_g_((int)p_214230_1_)) {
            this.pageEdit.func_238567_a_();
            return true;
        }
        switch (p_214230_1_) {
            case 257: 
            case 335: {
                this.pageEdit.func_216892_a("\n");
                return true;
            }
            case 259: {
                this.pageEdit.func_238586_d_(-1);
                return true;
            }
            case 261: {
                this.pageEdit.func_238586_d_(1);
                return true;
            }
            case 262: {
                this.pageEdit.func_238569_a_(1, Screen.func_231173_s_());
                return true;
            }
            case 263: {
                this.pageEdit.func_238569_a_(-1, Screen.func_231173_s_());
                return true;
            }
            case 266: {
                this.buttonPreviousPage.func_230930_b_();
                return true;
            }
            case 267: {
                this.buttonNextPage.func_230930_b_();
                return true;
            }
        }
        return false;
    }

    private String getText() {
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.size()) {
            return this.bookPages.func_150307_f(this.currPage);
        }
        return "";
    }

    private void setText(String par1Str) {
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.size()) {
            this.bookPages.set(this.currPage, (INBT)StringNBT.func_229705_a_((String)par1Str));
        }
    }

    private void setClipboard(String p_238760_1_) {
        if (this.field_230706_i_ != null) {
            TextInputUtil.func_238571_a_((Minecraft)this.field_230706_i_, (String)p_238760_1_);
        }
    }

    private String getClipboard() {
        return this.field_230706_i_ != null ? TextInputUtil.func_238576_b_((Minecraft)this.field_230706_i_) : "";
    }

    private void append(String par1Str) {
        String s1 = this.getText();
        String s2 = s1 + par1Str;
        int i = this.mc.field_71466_p.func_78267_b(s2 + "" + TextFormatting.BLACK + "_", 118);
        if (i <= 118 && s2.length() < 256) {
            this.setText(s2);
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float par3) {
        super.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(bookGuiTextures);
        this.func_238474_b_(matrixStack, this.guiLeft + 130, this.guiTop + 22, 0, 0, this.bookImageWidth, this.bookImageHeight / 3);
        this.func_238474_b_(matrixStack, this.guiLeft + 130, this.guiTop + 22 + this.bookImageHeight / 3, 0, this.bookImageHeight / 2, this.bookImageWidth, this.bookImageHeight / 2);
        this.func_238474_b_(matrixStack, this.guiLeft, this.guiTop + 2, 0, 0, this.bookImageWidth, this.bookImageHeight);
        this.field_230706_i_.func_110434_K().func_110577_a(bookInventory);
        this.func_238474_b_(matrixStack, this.guiLeft + 20, this.guiTop + 173, 0, 82, 180, 55);
        this.func_238474_b_(matrixStack, this.guiLeft + 20, this.guiTop + 228, 0, 140, 180, 28);
        String s = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.bookTotalPages});
        String s1 = "";
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.size()) {
            s1 = this.bookPages.func_150307_f(this.currPage);
        }
        if (this.canEdit) {
            s1 = this.updateCount / 6 % 2 == 0 ? s1 + "_" : (this.updateCount / 6 % 2 == 0 ? s1 + "" + TextFormatting.BLACK + "_" : s1 + "" + TextFormatting.GRAY + "_");
        }
        int l = this.mc.field_71466_p.func_78256_a(s);
        this.mc.field_71466_p.func_238421_b_(matrixStack, s, (float)(this.guiLeft - l + this.bookImageWidth - 44), (float)(this.guiTop + 18), 0);
        this.mc.field_71466_p.func_238418_a_((ITextProperties)new TranslationTextComponent(s1), this.guiLeft + 36, this.guiTop + 18 + 16, 116, 0);
        this.func_238468_a_(matrixStack, this.guiLeft + 175, this.guiTop + 136, this.guiLeft + 269, this.guiTop + 154, -1072689136, -804253680);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(bookWidgets);
        for (int i = 0; i < 4; ++i) {
            this.func_238474_b_(matrixStack, this.guiLeft + 175 + i * 24, this.guiTop + 134, 0, 22, 24, 24);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, par3);
    }

    @Override
    public void close() {
        this.mc.func_147108_a(parent);
        parent = null;
        mail = new PlayerMail();
    }

    @Override
    public void unFocused(GuiNpcTextField textfield) {
        if (textfield.id == 0) {
            this.username = textfield.func_146179_b();
        }
        if (textfield.id == 1) {
            GuiMailmanWrite.mail.subject = textfield.func_146179_b();
        }
        if (textfield.id == 2) {
            GuiMailmanWrite.mail.sender = textfield.func_146179_b();
        }
    }

    @Override
    public void setError(int i, CompoundNBT data) {
        if (i == 0) {
            this.error.label = new TranslationTextComponent("mailbox.errorUsername");
        }
        if (i == 1) {
            this.error.label = new TranslationTextComponent("mailbox.errorSubject");
        }
        this.hasSend = false;
    }

    @Override
    public void setClose(CompoundNBT data) {
        this.player.func_145747_a((ITextComponent)new TranslationTextComponent("mailbox.succes", new Object[]{data.func_74779_i("username")}), Util.field_240973_b_);
    }

    @Override
    public void save() {
    }

    static {
        mail = new PlayerMail();
    }
}

