/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import noppes.npcs.LogWriter;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityUtil {
    private static HashMap<EntityType<? extends Entity>, Class> entityClasses = new HashMap();

    public static void Copy(LivingEntity copied, LivingEntity entity) {
        EntityNPCInterface npc;
        entity.field_70170_p = copied.field_70170_p;
        entity.field_70725_aQ = copied.field_70725_aQ;
        entity.field_70140_Q = copied.field_70140_Q;
        entity.field_70141_P = copied.field_70140_Q;
        entity.field_82151_R = copied.field_82151_R;
        entity.field_191988_bg = copied.field_191988_bg;
        entity.field_70702_br = copied.field_70702_br;
        entity.func_230245_c_(copied.func_233570_aj_());
        entity.field_70143_R = copied.field_70143_R;
        entity.field_70703_bu = copied.field_70703_bu;
        List copiedData = copied.func_184212_Q().func_187231_c();
        List data = entity.func_184212_Q().func_187231_c();
        for (EntityDataManager.DataEntry entry : copiedData) {
            if (!data.stream().anyMatch(e -> e.func_187205_a() == entry.func_187205_a())) continue;
            entity.func_184212_Q().func_187227_b(entry.func_187205_a(), entry.func_187206_b());
        }
        entity.field_70169_q = copied.field_70169_q;
        entity.field_70167_r = copied.field_70167_r;
        entity.field_70166_s = copied.field_70166_s;
        entity.func_70107_b(copied.func_226277_ct_(), copied.func_226278_cu_(), copied.func_226281_cx_());
        entity.field_70142_S = copied.field_70142_S;
        entity.field_70137_T = copied.field_70137_T;
        entity.field_70136_U = copied.field_70136_U;
        entity.func_213317_d(copied.func_213322_ci());
        entity.field_70125_A = copied.field_70125_A;
        entity.field_70177_z = copied.field_70177_z;
        entity.field_70127_C = copied.field_70127_C;
        entity.field_70126_B = copied.field_70126_B;
        entity.field_70759_as = copied.field_70759_as;
        entity.field_70758_at = copied.field_70758_at;
        entity.field_70761_aq = copied.field_70761_aq;
        entity.field_70760_ar = copied.field_70760_ar;
        entity.field_184628_bn = copied.field_184628_bn;
        entity.field_184619_aG = copied.field_184619_aG;
        entity.field_70764_aw = copied.field_70764_aw;
        entity.field_70763_ax = copied.field_70763_ax;
        entity.field_205017_bL = copied.field_205017_bL;
        entity.field_205018_bM = copied.field_205018_bM;
        entity.field_82175_bq = copied.field_82175_bq;
        entity.field_110158_av = copied.field_110158_av;
        entity.field_70721_aZ = copied.field_70721_aZ;
        entity.field_184618_aE = copied.field_184618_aE;
        entity.field_70733_aJ = copied.field_70733_aJ;
        entity.field_70732_aI = copied.field_70732_aI;
        entity.field_70173_aa = copied.field_70173_aa;
        entity.func_70606_j(Math.min(copied.func_110143_aJ(), entity.func_110138_aP()));
        entity.getPersistentData().func_197643_a(copied.getPersistentData());
        if (entity instanceof PlayerEntity && copied instanceof PlayerEntity) {
            EquipmentSlotType[] ePlayer = (EquipmentSlotType[])entity;
            PlayerEntity cPlayer = (PlayerEntity)copied;
            ePlayer.field_71109_bG = cPlayer.field_71109_bG;
            ePlayer.field_71107_bF = cPlayer.field_71107_bF;
            ePlayer.field_71091_bM = cPlayer.field_71091_bM;
            ePlayer.field_71096_bN = cPlayer.field_71096_bN;
            ePlayer.field_71097_bO = cPlayer.field_71097_bO;
            ePlayer.field_71094_bP = cPlayer.field_71094_bP;
            ePlayer.field_71095_bQ = cPlayer.field_71095_bQ;
            ePlayer.field_71085_bR = cPlayer.field_71085_bR;
        }
        for (PlayerEntity playerEntity : EquipmentSlotType.values()) {
            entity.func_184201_a((EquipmentSlotType)playerEntity, copied.func_184582_a((EquipmentSlotType)playerEntity));
        }
        if (entity instanceof EnderDragonEntity) {
            entity.field_70125_A += 180.0f;
        }
        entity.field_70128_L = copied.field_70128_L;
        entity.field_70725_aQ = copied.field_70725_aQ;
        entity.field_70173_aa = copied.field_70173_aa;
        if (entity instanceof EnderDragonEntity) {
            entity.field_70177_z += 180.0f;
        }
        if (entity instanceof ChickenEntity) {
            ((ChickenEntity)entity).field_70886_e = copied.func_233570_aj_() ? 0.0f : 1.0f;
        }
        for (EquipmentSlotType equipmentSlotType : EquipmentSlotType.values()) {
            entity.func_184201_a(equipmentSlotType, copied.func_184582_a(equipmentSlotType));
        }
        if (copied instanceof EntityNPCInterface && entity instanceof EntityNPCInterface) {
            npc = (EntityNPCInterface)copied;
            EntityNPCInterface target = (EntityNPCInterface)entity;
            target.textureLocation = npc.textureLocation;
            target.textureGlowLocation = npc.textureGlowLocation;
            target.textureCloakLocation = npc.textureCloakLocation;
            target.display = npc.display;
            target.inventory = npc.inventory;
            if (npc.job.getType() == 9) {
                target.job = npc.job;
            }
            if (target.currentAnimation != npc.currentAnimation) {
                target.currentAnimation = npc.currentAnimation;
                npc.func_213323_x_();
            }
            target.setDataWatcher(npc.func_184212_Q());
        }
        if (entity instanceof EntityCustomNpc && copied instanceof EntityCustomNpc) {
            npc = (EntityCustomNpc)copied;
            EntityCustomNpc target = (EntityCustomNpc)entity;
            target.modelData = ((EntityCustomNpc)npc).modelData.copy();
            target.modelData.setEntity((String)null);
        }
    }

    private <T> void setData(LivingEntity entity, List<EntityDataManager.DataEntry<T>> copiedData, List<EntityDataManager.DataEntry<T>> data) {
        for (EntityDataManager.DataEntry entry : copiedData) {
            if (!data.stream().anyMatch(e -> e.func_187205_a() == entry.func_187205_a())) continue;
            entity.func_184212_Q().func_187227_b(entry.func_187205_a(), entry.func_187206_b());
        }
    }

    public static void setRecentlyHit(LivingEntity entity) {
        entity.field_70718_bc = 100;
    }

    public static HashMap<EntityType<? extends Entity>, Class> getAllEntitiesClasses(World level) {
        if (!entityClasses.isEmpty()) {
            return entityClasses;
        }
        HashMap<EntityType<? extends Entity>, Class> data = new HashMap<EntityType<? extends Entity>, Class>();
        for (EntityType ent : ForgeRegistries.ENTITIES.getValues()) {
            try {
                Entity e = ent.func_200721_a(level);
                if (e == null) continue;
                if (LivingEntity.class.isAssignableFrom(e.getClass())) {
                    data.put((EntityType<? extends Entity>)ent, e.getClass());
                }
                e.func_70106_y();
                e.field_70128_L = true;
            }
            catch (Exception exception) {}
        }
        entityClasses = data;
        return entityClasses;
    }

    public static HashMap<EntityType<? extends Entity>, Class> getAllEntitiesClassesNoNpcs(World level) {
        HashMap<EntityType<? extends Entity>, Class> data = new HashMap<EntityType<? extends Entity>, Class>(EntityUtil.getAllEntitiesClasses(level));
        Iterator<Map.Entry<EntityType<? extends Entity>, Class>> ita = data.entrySet().iterator();
        while (ita.hasNext()) {
            Map.Entry<EntityType<? extends Entity>, Class> entry = ita.next();
            if (!EntityNPCInterface.class.isAssignableFrom(entry.getValue()) && LivingEntity.class.isAssignableFrom(entry.getValue())) continue;
            ita.remove();
        }
        return data;
    }

    public static HashMap<String, ResourceLocation> getAllEntities(World level, boolean withNpcs) {
        HashMap<String, ResourceLocation> data = new HashMap<String, ResourceLocation>();
        for (EntityType ent : ForgeRegistries.ENTITIES.getValues()) {
            try {
                Entity e = ent.func_200721_a(level);
                if (e == null) continue;
                if (LivingEntity.class.isAssignableFrom(e.getClass()) && (withNpcs || !EntityNPCInterface.class.isAssignableFrom(e.getClass()))) {
                    data.put(ent.func_210760_d(), ent.getRegistryName());
                }
                e.func_70106_y();
                e.field_70128_L = true;
            }
            catch (Throwable e) {
                LogWriter.except(e);
            }
        }
        return data;
    }
}

