/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;

public class PlayerStateManager {
    private final ConcurrentHashMap<UUID, PlayerState> states;
    private final Server voicechatServer;

    public PlayerStateManager(Server voicechatServer) {
        this.voicechatServer = voicechatServer;
        this.states = new ConcurrentHashMap();
        CommonCompatibilityManager.INSTANCE.getNetManager().updateStateChannel.setServerListener((server, player, handler, packet) -> {
            PlayerState state = this.states.get(player.func_110124_au());
            if (state == null) {
                state = PlayerStateManager.defaultDisconnectedState(player);
            }
            state.setDisabled(packet.isDisabled());
            this.states.put(player.func_110124_au(), state);
            this.broadcastState(state);
            Voicechat.LOGGER.debug("Got state of {}: {}", player.func_145748_c_().getString(), state);
        });
    }

    public void broadcastState(PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        this.voicechatServer.getServer().func_184103_al().func_181057_v().forEach(p -> NetManager.sendToClient(p, packet));
        PluginManager.instance().onPlayerStateChanged(state);
    }

    public void onPlayerCompatibilityCheckSucceeded(ServerPlayerEntity player) {
        PlayerStatesPacket packet = new PlayerStatesPacket(this.states);
        NetManager.sendToClient(player, packet);
        Voicechat.LOGGER.debug("Sending initial states to {}", player.func_145748_c_().getString());
    }

    public void onPlayerLoggedIn(ServerPlayerEntity player) {
        PlayerState state = PlayerStateManager.defaultDisconnectedState(player);
        this.states.put(player.func_110124_au(), state);
        this.broadcastState(state);
        Voicechat.LOGGER.debug("Setting default state of {}: {}", player.func_145748_c_().getString(), state);
    }

    public void onPlayerLoggedOut(ServerPlayerEntity player) {
        this.states.remove(player.func_110124_au());
        this.broadcastState(new PlayerState(player.func_110124_au(), player.func_146103_bH().getName(), false, true));
        Voicechat.LOGGER.debug("Removing state of {}", player.func_145748_c_().getString());
    }

    public void onPlayerVoicechatDisconnect(UUID uuid) {
        PlayerState state = this.states.get(uuid);
        if (state == null) {
            return;
        }
        state.setDisconnected(true);
        this.broadcastState(state);
        Voicechat.LOGGER.debug("Set state of {} to disconnected: {}", uuid, state);
    }

    public void onPlayerVoicechatConnect(ServerPlayerEntity player) {
        PlayerState state = this.states.get(player.func_110124_au());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
        }
        state.setDisconnected(false);
        this.states.put(player.func_110124_au(), state);
        this.broadcastState(state);
        Voicechat.LOGGER.debug("Set state of {} to connected: {}", player.func_145748_c_().getString(), state);
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public static PlayerState defaultDisconnectedState(ServerPlayerEntity player) {
        return new PlayerState(player.func_110124_au(), player.func_146103_bH().getName(), false, true);
    }

    public void setGroup(ServerPlayerEntity player, @Nullable UUID group) {
        PlayerState state = this.states.get(player.func_110124_au());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
            Voicechat.LOGGER.debug("Defaulting to default state for {}: {}", player.func_145748_c_().getString(), state);
        }
        state.setGroup(group);
        this.states.put(player.func_110124_au(), state);
        this.broadcastState(state);
        Voicechat.LOGGER.debug("Setting group of {}: {}", player.func_145748_c_().getString(), state);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

