/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.service.Service;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;

public abstract class CommonCompatibilityManager {
    public static CommonCompatibilityManager INSTANCE = Service.get(CommonCompatibilityManager.class);

    public abstract String getModVersion();

    public abstract String getModName();

    public abstract Path getGameDirectory();

    public abstract void emitServerVoiceChatConnectedEvent(ServerPlayerEntity var1);

    public abstract void emitServerVoiceChatDisconnectedEvent(UUID var1);

    public abstract void emitPlayerCompatibilityCheckSucceeded(ServerPlayerEntity var1);

    public abstract void onServerVoiceChatConnected(Consumer<ServerPlayerEntity> var1);

    public abstract void onServerVoiceChatDisconnected(Consumer<UUID> var1);

    public abstract void onServerStarting(Consumer<MinecraftServer> var1);

    public abstract void onServerStopping(Consumer<MinecraftServer> var1);

    public abstract void onPlayerLoggedIn(Consumer<ServerPlayerEntity> var1);

    public abstract void onPlayerLoggedOut(Consumer<ServerPlayerEntity> var1);

    public abstract void onPlayerCompatibilityCheckSucceeded(Consumer<ServerPlayerEntity> var1);

    public abstract void onRegisterServerCommands(Consumer<CommandDispatcher<CommandSource>> var1);

    public abstract NetManager getNetManager();

    public abstract boolean isDevEnvironment();

    public abstract boolean isDedicatedServer();

    public abstract boolean isModLoaded(String var1);

    public abstract List<VoicechatPlugin> loadPlugins();

    public abstract PermissionManager createPermissionManager();
}

