/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class VoiceActivationSlider
extends DebouncedSlider
implements MicTestButton.MicListener {
    private static final ResourceLocation SLIDER = new ResourceLocation("voicechat", "textures/gui/voice_activation_slider.png");
    private static final ITextComponent NO_ACTIVATION = new TranslationTextComponent("message.voicechat.voice_activation.disabled").func_240699_a_(TextFormatting.RED);
    private double micValue;

    public VoiceActivationSlider(int x, int y, int width, int height) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(""), Utils.dbToPerc(VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.get().floatValue()));
        this.func_230979_b_();
    }

    protected void func_230441_a_(MatrixStack poseStack, Minecraft minecraft, int i, int j) {
        minecraft.func_110434_K().func_110577_a(SLIDER);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = (int)((double)(this.func_230998_h_() - 2) * this.micValue);
        this.func_238474_b_(poseStack, this.field_230690_l_ + 1, this.field_230691_m_ + 1, 0, 0, width, 18);
        super.func_230441_a_(poseStack, minecraft, i, j);
    }

    protected void func_230979_b_() {
        long db = Math.round(Utils.percToDb(this.field_230683_b_));
        TranslationTextComponent component = new TranslationTextComponent("message.voicechat.voice_activation", new Object[]{db});
        if (db >= -10L) {
            component.func_240699_a_(TextFormatting.RED);
        }
        this.func_238482_a_((ITextComponent)component);
    }

    @Nullable
    public ITextComponent getHoverText() {
        if (this.field_230683_b_ >= 1.0) {
            return NO_ACTIVATION;
        }
        return null;
    }

    public boolean func_230449_g_() {
        return this.field_230692_n_;
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.set(Utils.percToDb(this.field_230683_b_)).save();
    }

    @Override
    public void onMicValue(double percentage) {
        this.micValue = percentage;
    }
}

