/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.volume.VolumeEntry;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.Util;

public class PlayerVolumeEntry
extends VolumeEntry {
    @Nullable
    protected final PlayerState state;

    public PlayerVolumeEntry(@Nullable PlayerState state, AdjustVolumesScreen screen) {
        super(screen, new PlayerVolumeConfigEntry(state != null ? state.getUuid() : Util.field_240973_b_));
        this.state = state;
    }

    @Nullable
    public PlayerState getState() {
        return this.state;
    }

    @Override
    public void renderElement(MatrixStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta, int skinX, int skinY, int textX, int textY) {
        if (this.state != null) {
            this.minecraft.func_110434_K().func_110577_a(GameProfileUtils.getSkin(this.state.getUuid()));
            AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.enableBlend();
            AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.disableBlend();
            this.minecraft.field_71466_p.func_238421_b_(poseStack, this.state.getName(), (float)textX, (float)textY, PLAYER_NAME_COLOR);
        } else {
            this.minecraft.func_110434_K().func_110577_a(OTHER_VOLUME_ICON);
            AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
            this.minecraft.field_71466_p.func_243248_b(poseStack, OTHER_VOLUME, (float)textX, (float)textY, PLAYER_NAME_COLOR);
            if (hovered) {
                this.screen.postRender(() -> this.screen.func_238652_a_(poseStack, OTHER_VOLUME_DESCRIPTION, mouseX, mouseY));
            }
        }
    }

    public static class PlayerVolumeConfigEntry
    implements AdjustVolumeSlider.VolumeConfigEntry {
        private final UUID playerUUID;

        public PlayerVolumeConfigEntry(UUID playerUUID) {
            this.playerUUID = playerUUID;
        }

        @Override
        public void save(double value) {
            VoicechatClient.VOLUME_CONFIG.setPlayerVolume(this.playerUUID, value);
            VoicechatClient.VOLUME_CONFIG.save();
        }

        @Override
        public double get() {
            return VoicechatClient.VOLUME_CONFIG.getPlayerVolume(this.playerUUID);
        }
    }
}

