/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.group.JoinGroupEntry;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class JoinGroupList
extends ListScreenListBase<JoinGroupEntry> {
    protected final ListScreenBase parent;

    public JoinGroupList(ListScreenBase parent, int width, int height, int top, int size) {
        super(width, height, top, size);
        this.parent = parent;
        this.func_244605_b(false);
        this.func_244606_c(false);
        this.updateGroups();
    }

    private void updateGroups() {
        Map<UUID, JoinGroupEntry.Group> groups = ClientManager.getGroupManager().getGroups().stream().filter(clientGroup -> !clientGroup.isHidden()).collect(Collectors.toMap(ClientGroup::getId, JoinGroupEntry.Group::new));
        List<PlayerState> playerStates = ClientManager.getPlayerStateManager().getPlayerStates(true);
        for (PlayerState state : playerStates) {
            JoinGroupEntry.Group group2;
            if (!state.hasGroup() || (group2 = groups.get(state.getGroup())) == null) continue;
            group2.getMembers().add(state);
        }
        groups.values().forEach(group -> group.getMembers().sort(Comparator.comparing(PlayerState::getName)));
        this.func_230942_a_(groups.values().stream().map(group -> new JoinGroupEntry(this.parent, (JoinGroupEntry.Group)group)).sorted(Comparator.comparing(o -> o.getGroup().getGroup().getName())).collect(Collectors.toList()));
    }

    public static void update() {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof JoinGroupScreen) {
            JoinGroupScreen joinGroupScreen = (JoinGroupScreen)screen;
            joinGroupScreen.groupList.updateGroups();
        }
    }

    public boolean isEmpty() {
        return this.func_231039_at__().isEmpty();
    }
}

