/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.GroupType;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class JoinGroupEntry
extends ListScreenEntryBase<JoinGroupEntry> {
    protected static final ResourceLocation LOCK = new ResourceLocation("voicechat", "textures/icons/lock.png");
    protected static final ITextComponent GROUP_MEMBERS = new TranslationTextComponent("message.voicechat.group_members").func_240699_a_(TextFormatting.GRAY);
    protected static final ITextComponent NO_GROUP_MEMBERS = new TranslationTextComponent("message.voicechat.no_group_members").func_240699_a_(TextFormatting.GRAY);
    protected static final int SKIN_SIZE = 12;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = ColorHelper.PackedColor.func_233006_a_((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_SELECTED = ColorHelper.PackedColor.func_233006_a_((int)255, (int)90, (int)90, (int)90);
    protected static final int PLAYER_NAME_COLOR = ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255);
    protected final ListScreenBase parent;
    protected final Minecraft minecraft;
    protected final Group group;

    public JoinGroupEntry(ListScreenBase parent, Group group) {
        this.parent = parent;
        this.minecraft = Minecraft.func_71410_x();
        this.group = group;
    }

    public void func_230432_a_(MatrixStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        if (hovered) {
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL_SELECTED);
        } else {
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL);
        }
        boolean hasPassword = this.group.group.hasPassword();
        if (hasPassword) {
            poseStack.func_227860_a_();
            poseStack.func_227861_a_((double)(left + 4), (double)((float)top + (float)height / 2.0f - 8.0f), 0.0);
            poseStack.func_227862_a_(1.3333334f, 1.3333334f, 1.0f);
            this.minecraft.func_110434_K().func_110577_a(LOCK);
            Screen.func_238463_a_((MatrixStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)12, (int)12, (int)16, (int)16);
            poseStack.func_227865_b_();
        }
        StringTextComponent groupName = new StringTextComponent(this.group.group.getName());
        FontRenderer fontRenderer = this.minecraft.field_71466_p;
        float f = left + 4 + (hasPassword ? 20 : 0);
        int n = top + height / 2;
        this.minecraft.field_71466_p.getClass();
        fontRenderer.func_243248_b(poseStack, (ITextComponent)groupName, f, (float)(n - 9 / 2), PLAYER_NAME_COLOR);
        int textWidth = this.minecraft.field_71466_p.func_238414_a_((ITextProperties)groupName) + (hasPassword ? 20 : 0);
        int headsPerRow = (width - (4 + textWidth + 4 + 4)) / 13;
        int rows = 2;
        for (int i = 0; i < this.group.members.size(); ++i) {
            PlayerState state = (PlayerState)this.group.members.get(i);
            int headXIndex = i / rows;
            int headYIndex = i % rows;
            if (i >= headsPerRow * rows) break;
            int headPosX = left + width - 12 - 4 - headXIndex * 13;
            int headPosY = top + height / 2 - 13 + 13 * headYIndex;
            poseStack.func_227860_a_();
            this.minecraft.func_110434_K().func_110577_a(GameProfileUtils.getSkin(state.getUuid()));
            poseStack.func_227861_a_((double)headPosX, (double)headPosY, 0.0);
            float scale = 1.5f;
            poseStack.func_227862_a_(scale, scale, scale);
            Screen.func_238463_a_((MatrixStack)poseStack, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.enableBlend();
            Screen.func_238463_a_((MatrixStack)poseStack, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.disableBlend();
            poseStack.func_227865_b_();
        }
        if (!hovered) {
            return;
        }
        ArrayList tooltip = Lists.newArrayList();
        if (this.group.getGroup().getType().equals(Group.Type.NORMAL)) {
            tooltip.add(new TranslationTextComponent("message.voicechat.group_title", new Object[]{new StringTextComponent(this.group.getGroup().getName())}).func_241878_f());
        } else {
            tooltip.add(new TranslationTextComponent("message.voicechat.group_type_title", new Object[]{new StringTextComponent(this.group.getGroup().getName()), GroupType.fromType(this.group.getGroup().getType()).getTranslation()}).func_241878_f());
        }
        if (this.group.getMembers().isEmpty()) {
            tooltip.add(NO_GROUP_MEMBERS.func_241878_f());
        } else {
            tooltip.add(GROUP_MEMBERS.func_241878_f());
            int maxMembers = 10;
            for (int i = 0; i < this.group.getMembers().size(); ++i) {
                if (i >= maxMembers) {
                    tooltip.add(new TranslationTextComponent("message.voicechat.more_members", new Object[]{this.group.getMembers().size() - maxMembers}).func_240699_a_(TextFormatting.GRAY).func_241878_f());
                    break;
                }
                PlayerState state = this.group.getMembers().get(i);
                tooltip.add(new StringTextComponent("  " + state.getName()).func_240699_a_(TextFormatting.GRAY).func_241878_f());
            }
        }
        this.parent.postRender(() -> this.parent.func_238654_b_(poseStack, tooltip, mouseX, mouseY));
    }

    public Group getGroup() {
        return this.group;
    }

    public static class Group {
        private final ClientGroup group;
        private final List<PlayerState> members;

        public Group(ClientGroup group) {
            this.group = group;
            this.members = new ArrayList<PlayerState>();
        }

        public ClientGroup getGroup() {
            return this.group;
        }

        public List<PlayerState> getMembers() {
            return this.members;
        }
    }
}

