/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.group.GroupEntry;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;

public class GroupList
extends ListScreenListBase<GroupEntry> {
    protected final ListScreenBase parent;

    public GroupList(ListScreenBase parent, int width, int height, int top, int size) {
        super(width, height, top, size);
        this.parent = parent;
        this.func_244605_b(false);
        this.func_244606_c(false);
        this.updateMembers();
    }

    public void updateMembers() {
        List<PlayerState> playerStates = ClientManager.getPlayerStateManager().getPlayerStates(true);
        UUID group = ClientManager.getPlayerStateManager().getGroupID();
        if (group == null) {
            this.func_230963_j_();
            this.field_230668_b_.func_147108_a(null);
            return;
        }
        boolean changed = false;
        LinkedList<GroupEntry> toRemove = new LinkedList<GroupEntry>();
        for (GroupEntry entry : this.func_231039_at__()) {
            PlayerState state = ClientManager.getPlayerStateManager().getState(entry.getState().getUuid());
            if (state == null) {
                toRemove.add(entry);
                changed = true;
                continue;
            }
            entry.setState(state);
            if (this.isInGroup(state, group)) continue;
            toRemove.add(entry);
            changed = true;
        }
        for (GroupEntry entry : toRemove) {
            this.func_230956_e_((AbstractList.AbstractListEntry)entry);
        }
        for (PlayerState state : playerStates) {
            if (!this.isInGroup(state, group) || !this.func_231039_at__().stream().noneMatch(groupEntry -> groupEntry.getState().getUuid().equals(state.getUuid()))) continue;
            this.func_230513_b_((AbstractList.AbstractListEntry)new GroupEntry(this.parent, state));
            changed = true;
        }
        if (changed) {
            this.func_231039_at__().sort(Comparator.comparing(o -> o.getState().getName()));
        }
    }

    public static void update() {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GroupScreen) {
            GroupScreen groupScreen = (GroupScreen)screen;
            groupScreen.groupList.updateMembers();
        }
    }

    private boolean isInGroup(PlayerState state, UUID group) {
        return state.hasGroup() && state.getGroup().equals(group);
    }
}

