/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.configbuilder.entry.ConfigEntry;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class AudioDeviceList
extends ListScreenListBase<AudioDeviceEntry> {
    public static final int CELL_HEIGHT = 36;
    @Nullable
    protected ResourceLocation icon;
    @Nullable
    protected ConfigEntry<String> configEntry;

    public AudioDeviceList(int width, int height, int top) {
        super(width, height, top, 36);
        this.func_244605_b(false);
        this.func_244606_c(false);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (super.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        AudioDeviceEntry entry = (AudioDeviceEntry)this.func_230933_a_(mouseX, mouseY);
        if (entry == null) {
            return false;
        }
        if (!this.func_231047_b_(mouseX, mouseY)) {
            return false;
        }
        if (!this.isSelected(entry.getDevice())) {
            this.field_230668_b_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.onSelect(entry);
            return true;
        }
        return false;
    }

    protected void onSelect(AudioDeviceEntry entry) {
        ClientVoicechat client;
        if (this.configEntry != null) {
            this.configEntry.set(entry.device).save();
        }
        if ((client = ClientManager.getClient()) != null) {
            client.reloadAudio();
        }
    }

    public AudioDeviceList setIcon(@Nullable ResourceLocation icon) {
        this.icon = icon;
        return this;
    }

    public AudioDeviceList setConfigEntry(@Nullable ConfigEntry<String> configEntry) {
        this.configEntry = configEntry;
        return this;
    }

    public void func_230942_a_(Collection<AudioDeviceEntry> entries) {
        super.func_230942_a_(entries);
    }

    public void setAudioDevices(Collection<String> entries) {
        this.func_230942_a_(entries.stream().map(s -> new AudioDeviceEntry((String)s, this.getVisibleName((String)s), this.icon, () -> this.isSelected((String)s))).collect(Collectors.toList()));
    }

    public boolean isSelected(String name) {
        if (this.configEntry == null) {
            return false;
        }
        return this.configEntry.get().equals(name);
    }

    public String getVisibleName(String device) {
        return SoundManager.cleanDeviceName(device);
    }

    public boolean isEmpty() {
        return this.func_231039_at__().isEmpty();
    }
}

