/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;

public class AudioDeviceEntry
extends ListScreenEntryBase<AudioDeviceEntry> {
    protected static final ResourceLocation SELECTED = new ResourceLocation("voicechat", "textures/icons/device_selected.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = ColorHelper.PackedColor.func_233006_a_((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_HOVERED = ColorHelper.PackedColor.func_233006_a_((int)255, (int)90, (int)90, (int)90);
    protected static final int BG_FILL_SELECTED = ColorHelper.PackedColor.func_233006_a_((int)255, (int)40, (int)40, (int)40);
    protected static final int DEVICE_NAME_COLOR = ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255);
    protected final Minecraft minecraft;
    protected final String device;
    protected final String visibleDeviceName;
    @Nullable
    protected final ResourceLocation icon;
    protected final Supplier<Boolean> isSelected;

    public AudioDeviceEntry(String device, String name, @Nullable ResourceLocation icon, Supplier<Boolean> isSelected) {
        this.device = device;
        this.icon = icon;
        this.isSelected = isSelected;
        this.visibleDeviceName = name;
        this.minecraft = Minecraft.func_71410_x();
    }

    public void func_230432_a_(MatrixStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        boolean selected = this.isSelected.get();
        if (selected) {
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL_SELECTED);
        } else if (hovered) {
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL_HOVERED);
        } else {
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL);
        }
        if (this.icon != null) {
            this.minecraft.func_110434_K().func_110577_a(this.icon);
            AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)(left + 4), (int)(top + height / 2 - 8), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
        }
        if (selected) {
            this.minecraft.func_110434_K().func_110577_a(SELECTED);
            AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)(left + 4), (int)(top + height / 2 - 8), (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
        }
        float deviceWidth = this.minecraft.field_71466_p.func_78256_a(this.visibleDeviceName);
        float space = width - 4 - 16 - 4 - 4;
        float scale = Math.min(space / deviceWidth, 1.0f);
        poseStack.func_227860_a_();
        double d = left + 4 + 16 + 4;
        float f = top + height / 2;
        this.minecraft.field_71466_p.getClass();
        poseStack.func_227861_a_(d, (double)(f - 9.0f * scale / 2.0f), 0.0);
        poseStack.func_227862_a_(scale, scale, 1.0f);
        this.minecraft.field_71466_p.func_238421_b_(poseStack, this.visibleDeviceName, 0.0f, 0.0f, DEVICE_NAME_COLOR);
        poseStack.func_227865_b_();
    }

    public String getDevice() {
        return this.device;
    }
}

