/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.audiodevice.SelectMicrophoneScreen;
import de.maxhenkel.voicechat.gui.audiodevice.SelectSpeakerScreen;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.DenoiserButton;
import de.maxhenkel.voicechat.gui.widgets.EnumButton;
import de.maxhenkel.voicechat.gui.widgets.KeybindButton;
import de.maxhenkel.voicechat.gui.widgets.MicActivationButton;
import de.maxhenkel.voicechat.gui.widgets.MicAmplificationSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.gui.widgets.VoiceActivationSlider;
import de.maxhenkel.voicechat.gui.widgets.VoiceSoundSlider;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class VoiceChatSettingsScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_voicechat_settings.png");
    private static final ITextComponent TITLE = new TranslationTextComponent("gui.voicechat.voice_chat_settings.title");
    private static final ITextComponent ASSIGN_TOOLTIP = new TranslationTextComponent("message.voicechat.press_to_reassign_key");
    private static final ITextComponent PUSH_TO_TALK = new TranslationTextComponent("message.voicechat.activation_type.ptt");
    private static final ITextComponent ADJUST_VOLUMES = new TranslationTextComponent("message.voicechat.adjust_volumes");
    private static final ITextComponent SELECT_MICROPHONE = new TranslationTextComponent("message.voicechat.select_microphone");
    private static final ITextComponent SELECT_SPEAKER = new TranslationTextComponent("message.voicechat.select_speaker");
    private static final ITextComponent BACK = new TranslationTextComponent("message.voicechat.back");
    @Nullable
    private final Screen parent;
    private VoiceActivationSlider voiceActivationSlider;
    private MicTestButton micTestButton;
    private KeybindButton keybindButton;

    public VoiceChatSettingsScreen(@Nullable Screen parent) {
        super(TITLE, 248, 219);
        this.parent = parent;
    }

    public VoiceChatSettingsScreen() {
        this(null);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int y = this.guiTop + 20;
        this.func_230480_a_((Widget)new VoiceSoundSlider(this.guiLeft + 10, y, this.xSize - 20, 20));
        this.func_230480_a_((Widget)new MicAmplificationSlider(this.guiLeft + 10, y += 21, this.xSize - 20, 20));
        this.func_230480_a_((Widget)new DenoiserButton(this.guiLeft + 10, y += 21, this.xSize - 20, 20));
        this.voiceActivationSlider = new VoiceActivationSlider(this.guiLeft + 10 + 20 + 1, (y += 21) + 21, this.xSize - 20 - 20 - 1, 20);
        this.micTestButton = new MicTestButton(this.guiLeft + 10, y + 21, this.voiceActivationSlider);
        this.keybindButton = new KeybindButton(KeyEvents.KEY_PTT, this.guiLeft + 10 + 20 + 1, y + 21, this.xSize - 20 - 20 - 1, 20, PUSH_TO_TALK);
        this.func_230480_a_((Widget)new MicActivationButton(this.guiLeft + 10, y, this.xSize - 20, 20, type -> {
            this.voiceActivationSlider.field_230694_p_ = MicrophoneActivationType.VOICE.equals(type);
            this.keybindButton.field_230694_p_ = MicrophoneActivationType.PTT.equals(type);
        }));
        this.func_230480_a_((Widget)this.micTestButton);
        this.func_230480_a_((Widget)this.voiceActivationSlider);
        this.func_230480_a_((Widget)this.keybindButton);
        this.func_230480_a_((Widget)new EnumButton<AudioType>(this.guiLeft + 10, y += 42, this.xSize - 20, 20, VoicechatClient.CLIENT_CONFIG.audioType){

            @Override
            protected ITextComponent getText(AudioType type) {
                return new TranslationTextComponent("message.voicechat.audio_type", new Object[]{type.getText()});
            }

            @Override
            protected void onUpdate(AudioType type) {
                ClientVoicechat client = ClientManager.getClient();
                if (client != null) {
                    VoiceChatSettingsScreen.this.micTestButton.stop();
                    client.reloadAudio();
                }
            }
        });
        y += 21;
        if (this.isIngame()) {
            this.func_230480_a_((Widget)new Button(this.guiLeft + 10, y, this.xSize - 20, 20, ADJUST_VOLUMES, button -> this.field_230706_i_.func_147108_a((Screen)new AdjustVolumesScreen())));
            y += 21;
        }
        this.func_230480_a_((Widget)new Button(this.guiLeft + 10, y, this.xSize / 2 - 15, 20, SELECT_MICROPHONE, button -> this.field_230706_i_.func_147108_a((Screen)new SelectMicrophoneScreen(this))));
        this.func_230480_a_((Widget)new Button(this.guiLeft + this.xSize / 2 + 1, y, (this.xSize - 20) / 2 - 1, 20, SELECT_SPEAKER, button -> this.field_230706_i_.func_147108_a((Screen)new SelectSpeakerScreen(this))));
        y += 21;
        if (!this.isIngame() && this.parent != null) {
            this.func_230480_a_((Widget)new Button(this.guiLeft + 10, y, this.xSize - 20, 20, BACK, button -> this.field_230706_i_.func_147108_a(this.parent)));
        }
    }

    @Override
    public void renderBackground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        if (this.isIngame()) {
            this.func_238474_b_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
    }

    @Override
    public void renderForeground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        int titleWidth = this.field_230712_o_.func_238414_a_((ITextProperties)TITLE);
        this.field_230712_o_.func_238422_b_(poseStack, TITLE.func_241878_f(), (float)(this.guiLeft + (this.xSize - titleWidth) / 2), (float)(this.guiTop + 7), this.getFontColor());
        ITextComponent sliderTooltip = this.voiceActivationSlider.getHoverText();
        if (this.voiceActivationSlider.func_230449_g_() && sliderTooltip != null) {
            this.func_238652_a_(poseStack, sliderTooltip, mouseX, mouseY);
        } else if (this.micTestButton.func_230449_g_()) {
            this.micTestButton.func_230443_a_(poseStack, mouseX, mouseY);
        } else if (this.keybindButton.func_230449_g_()) {
            this.func_238652_a_(poseStack, ASSIGN_TOOLTIP, mouseX, mouseY);
        }
    }

    public boolean func_231178_ax__() {
        if (this.keybindButton.isListening()) {
            return false;
        }
        return super.func_231178_ax__();
    }
}

