/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.RecordingTooltipSupplier;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class VoiceChatScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_voicechat.png");
    private static final ResourceLocation MICROPHONE = new ResourceLocation("voicechat", "textures/icons/microphone_button.png");
    private static final ResourceLocation HIDE = new ResourceLocation("voicechat", "textures/icons/hide_button.png");
    private static final ResourceLocation VOLUMES = new ResourceLocation("voicechat", "textures/icons/adjust_volumes.png");
    private static final ResourceLocation SPEAKER = new ResourceLocation("voicechat", "textures/icons/speaker_button.png");
    private static final ResourceLocation RECORD = new ResourceLocation("voicechat", "textures/icons/record_button.png");
    private static final ITextComponent TITLE = new TranslationTextComponent("gui.voicechat.voice_chat.title");
    private static final ITextComponent SETTINGS = new TranslationTextComponent("message.voicechat.settings");
    private static final ITextComponent GROUP = new TranslationTextComponent("message.voicechat.group");
    private static final ITextComponent ADJUST_PLAYER_VOLUMES = new TranslationTextComponent("message.voicechat.adjust_volumes");
    private ToggleImageButton mute;
    private ToggleImageButton disable;
    private VoiceChatScreenBase.HoverArea recordingHoverArea;
    private ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();

    public VoiceChatScreen() {
        super(TITLE, 195, 76);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        ClientVoicechat client = ClientManager.getClient();
        this.mute = new ToggleImageButton(this.guiLeft + 6, this.guiTop + this.ySize - 6 - 20, MICROPHONE, this.stateManager::isMuted, button -> this.stateManager.setMuted(!this.stateManager.isMuted()), new MuteTooltipSupplier(this, this.stateManager));
        this.func_230480_a_((Widget)this.mute);
        this.disable = new ToggleImageButton(this.guiLeft + 6 + 20 + 2, this.guiTop + this.ySize - 6 - 20, SPEAKER, this.stateManager::isDisabled, button -> this.stateManager.setDisabled(!this.stateManager.isDisabled()), new DisableTooltipSupplier(this, this.stateManager));
        this.func_230480_a_((Widget)this.disable);
        ImageButton volumes = new ImageButton(this.guiLeft + 6 + 20 + 2 + 20 + 2, this.guiTop + this.ySize - 6 - 20, VOLUMES, button -> this.field_230706_i_.func_147108_a((Screen)new AdjustVolumesScreen()), (button, matrices, mouseX, mouseY) -> this.func_238652_a_(matrices, ADJUST_PLAYER_VOLUMES, mouseX, mouseY));
        this.func_230480_a_((Widget)volumes);
        if (client != null && VoicechatClient.CLIENT_CONFIG.useNatives.get().booleanValue() && (client.getRecorder() != null || client.getConnection() != null && client.getConnection().getData().allowRecording())) {
            ToggleImageButton record = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20 - 2 - 20, this.guiTop + this.ySize - 6 - 20, RECORD, () -> ClientManager.getClient() != null && ClientManager.getClient().getRecorder() != null, button -> this.toggleRecording(), new RecordingTooltipSupplier(this));
            this.func_230480_a_((Widget)record);
        }
        ToggleImageButton hide = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20, this.guiTop + this.ySize - 6 - 20, HIDE, VoicechatClient.CLIENT_CONFIG.hideIcons::get, button -> VoicechatClient.CLIENT_CONFIG.hideIcons.set(VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false).save(), new HideTooltipSupplier(this));
        this.func_230480_a_((Widget)hide);
        Button settings = new Button(this.guiLeft + 6, this.guiTop + 6 + 15, 75, 20, SETTINGS, button -> this.field_230706_i_.func_147108_a((Screen)new VoiceChatSettingsScreen()));
        this.func_230480_a_((Widget)settings);
        Button group = new Button(this.guiLeft + this.xSize - 6 - 75 + 1, this.guiTop + 6 + 15, 75, 20, GROUP, button -> {
            ClientGroup g = this.stateManager.getGroup();
            if (g != null) {
                this.field_230706_i_.func_147108_a((Screen)new GroupScreen(g));
            } else {
                this.field_230706_i_.func_147108_a((Screen)new JoinGroupScreen());
            }
        });
        this.func_230480_a_((Widget)group);
        group.field_230693_o_ = client != null && client.getConnection() != null && client.getConnection().getData().groupsEnabled();
        this.recordingHoverArea = new VoiceChatScreenBase.HoverArea(72, this.ySize - 6 - 20, this.xSize - 122, 20);
        this.checkButtons();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.checkButtons();
    }

    private void checkButtons() {
        this.mute.field_230693_o_ = MuteTooltipSupplier.canMuteMic();
        this.disable.field_230693_o_ = this.stateManager.canEnable();
    }

    private void toggleRecording() {
        ClientVoicechat c = ClientManager.getClient();
        if (c == null) {
            return;
        }
        c.toggleRecording();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_VOICE_CHAT).func_197937_c()) {
            this.field_230706_i_.func_147108_a(null);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    public void renderBackground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public void renderForeground(MatrixStack poseStack, int mouseX, int mouseY, float delta) {
        int titleWidth = this.field_230712_o_.func_238414_a_((ITextProperties)TITLE);
        this.field_230712_o_.func_238422_b_(poseStack, TITLE.func_241878_f(), (float)(this.guiLeft + (this.xSize - titleWidth) / 2), (float)(this.guiTop + 7), 0x404040);
        ClientVoicechat client = ClientManager.getClient();
        if (client != null && client.getRecorder() != null) {
            AudioRecorder recorder = client.getRecorder();
            StringTextComponent time = new StringTextComponent(recorder.getDuration());
            IFormattableTextComponent iFormattableTextComponent = time.func_240699_a_(TextFormatting.DARK_RED);
            float f = (float)(this.guiLeft + this.recordingHoverArea.getPosX()) + (float)this.recordingHoverArea.getWidth() / 2.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)time) / 2.0f;
            float f2 = (float)(this.guiTop + this.recordingHoverArea.getPosY()) + (float)this.recordingHoverArea.getHeight() / 2.0f;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_243248_b(poseStack, (ITextComponent)iFormattableTextComponent, f, f2 - 9.0f / 2.0f, 0);
            if (this.recordingHoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) {
                this.func_238652_a_(poseStack, (ITextComponent)new TranslationTextComponent("message.voicechat.storage_size", new Object[]{recorder.getStorage()}), mouseX, mouseY);
            }
        }
    }
}

