/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.command.GroupNameSuggestionProvider;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.permission.Permission;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.UUIDArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class VoicechatCommands {
    public static final String VOICECHAT_COMMAND = "voicechat";

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder literalBuilder = Commands.func_197057_a((String)VOICECHAT_COMMAND);
        literalBuilder.executes(commandSource -> VoicechatCommands.help(dispatcher, (CommandContext<CommandSource>)commandSource));
        literalBuilder.then(Commands.func_197057_a((String)"help").executes(commandSource -> VoicechatCommands.help(dispatcher, (CommandContext<CommandSource>)commandSource)));
        literalBuilder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"test").requires(commandSource -> VoicechatCommands.checkPermission(commandSource, PermissionManager.INSTANCE.ADMIN_PERMISSION))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSource>)commandSource)) {
                return 0;
            }
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)commandSource, (String)"target");
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            if (!Voicechat.SERVER.isCompatible(player)) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.player_no_voicechat", new Object[]{player.func_145748_c_(), CommonCompatibilityManager.INSTANCE.getModName()}), false);
                return 1;
            }
            ClientConnection clientConnection = server.getConnections().get(player.func_110124_au());
            if (clientConnection == null) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.client_not_connected"), false);
                return 1;
            }
            try {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.sending_ping"), false);
                server.getPingManager().sendPing(clientConnection, 500L, 10, new PingManager.PingListener(){

                    @Override
                    public void onPong(int attempts, long pingMilliseconds) {
                        if (attempts <= 1) {
                            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.ping_received", new Object[]{pingMilliseconds}), false);
                        } else {
                            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.ping_received_attempt", new Object[]{attempts, pingMilliseconds}), false);
                        }
                    }

                    @Override
                    public void onFailedAttempt(int attempts) {
                        ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.ping_retry"), false);
                    }

                    @Override
                    public void onTimeout(int attempts) {
                        ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.ping_timed_out", new Object[]{attempts}), false);
                    }
                });
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.ping_sent_waiting"), false);
            }
            catch (Exception e) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.failed_to_send_ping", new Object[]{e.getMessage()}), false);
                Voicechat.LOGGER.warn("Failed to send ping", e);
                return 1;
            }
            return 1;
        })));
        literalBuilder.then(Commands.func_197057_a((String)"invite").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSource>)commandSource)) {
                return 0;
            }
            ServerPlayerEntity source = ((CommandSource)commandSource.getSource()).func_197035_h();
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            PlayerState state = server.getPlayerStateManager().getState(source.func_110124_au());
            if (state == null || !state.hasGroup()) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.not_in_group"), false);
                return 1;
            }
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)commandSource, (String)"target");
            Group group = server.getGroupManager().getGroup(state.getGroup());
            if (group == null) {
                return 1;
            }
            if (!Voicechat.SERVER.isCompatible(player)) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.player_no_voicechat", new Object[]{player.func_145748_c_(), CommonCompatibilityManager.INSTANCE.getModName()}), false);
                return 1;
            }
            String passwordSuffix = group.getPassword() == null ? "" : " \"" + group.getPassword() + "\"";
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.voicechat.invite", new Object[]{source.func_145748_c_(), new StringTextComponent(group.getName()).func_240699_a_(TextFormatting.GRAY), TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("message.voicechat.accept_invite").func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/voicechat join " + group.getId().toString() + passwordSuffix)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("message.voicechat.accept_invite.hover"))))).func_240699_a_(TextFormatting.GREEN)}), Util.field_240973_b_);
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.invite_successful", new Object[]{player.func_145748_c_()}), false);
            return 1;
        })));
        literalBuilder.then(Commands.func_197057_a((String)"join").then(Commands.func_197056_a((String)"group_id", (ArgumentType)UUIDArgument.func_239194_a_()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSource>)commandSource)) {
                return 0;
            }
            UUID groupID = UUIDArgument.func_239195_a_((CommandContext)commandSource, (String)"group_id");
            return VoicechatCommands.joinGroupById((CommandSource)commandSource.getSource(), groupID, null);
        })));
        literalBuilder.then(Commands.func_197057_a((String)"join").then(Commands.func_197056_a((String)"group_id", (ArgumentType)UUIDArgument.func_239194_a_()).then(Commands.func_197056_a((String)"password", (ArgumentType)StringArgumentType.string()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSource>)commandSource)) {
                return 0;
            }
            UUID groupID = UUIDArgument.func_239195_a_((CommandContext)commandSource, (String)"group_id");
            String password = StringArgumentType.getString((CommandContext)commandSource, (String)"password");
            return VoicechatCommands.joinGroupById((CommandSource)commandSource.getSource(), groupID, password.isEmpty() ? null : password);
        }))));
        literalBuilder.then(Commands.func_197057_a((String)"join").then(Commands.func_197056_a((String)"group_name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)GroupNameSuggestionProvider.INSTANCE).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSource>)commandSource)) {
                return 0;
            }
            String groupName = StringArgumentType.getString((CommandContext)commandSource, (String)"group_name");
            return VoicechatCommands.joinGroupByName((CommandSource)commandSource.getSource(), groupName, null);
        })));
        literalBuilder.then(Commands.func_197057_a((String)"join").then(Commands.func_197056_a((String)"group_name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)GroupNameSuggestionProvider.INSTANCE).then(Commands.func_197056_a((String)"password", (ArgumentType)StringArgumentType.string()).executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSource>)commandSource)) {
                return 0;
            }
            String groupName = StringArgumentType.getString((CommandContext)commandSource, (String)"group_name");
            String password = StringArgumentType.getString((CommandContext)commandSource, (String)"password");
            return VoicechatCommands.joinGroupByName((CommandSource)commandSource.getSource(), groupName, password.isEmpty() ? null : password);
        }))));
        literalBuilder.then(Commands.func_197057_a((String)"leave").executes(commandSource -> {
            if (VoicechatCommands.checkNoVoicechat((CommandContext<CommandSource>)commandSource)) {
                return 0;
            }
            if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
                ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.voicechat.groups_disabled"));
                return 1;
            }
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            ServerPlayerEntity source = ((CommandSource)commandSource.getSource()).func_197035_h();
            PlayerState state = server.getPlayerStateManager().getState(source.func_110124_au());
            if (state == null || !state.hasGroup()) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.not_in_group"), false);
                return 1;
            }
            server.getGroupManager().leaveGroup(source);
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.leave_successful"), false);
            return 1;
        }));
        dispatcher.register(literalBuilder);
    }

    private static Server joinGroup(CommandSource source) throws CommandSyntaxException {
        if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("message.voicechat.groups_disabled"));
            return null;
        }
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.voice_chat_unavailable"), false);
            return null;
        }
        ServerPlayerEntity player = source.func_197035_h();
        if (!PermissionManager.INSTANCE.GROUPS_PERMISSION.hasPermission(player)) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.no_group_permission"), false);
            return null;
        }
        return server;
    }

    private static int joinGroupByName(CommandSource source, String groupName, @Nullable String password) throws CommandSyntaxException {
        Server server = VoicechatCommands.joinGroup(source);
        if (server == null) {
            return 1;
        }
        List groups = server.getGroupManager().getGroups().values().stream().filter(group -> group.getName().equals(groupName)).collect(Collectors.toList());
        if (groups.isEmpty()) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("message.voicechat.group_does_not_exist"));
            return 1;
        }
        if (groups.size() > 1) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("message.voicechat.group_name_not_unique"));
            return 1;
        }
        return VoicechatCommands.joinGroup(source, server, ((Group)groups.get(0)).getId(), password);
    }

    private static int joinGroupById(CommandSource source, UUID groupID, @Nullable String password) throws CommandSyntaxException {
        Server server = VoicechatCommands.joinGroup(source);
        if (server == null) {
            return 1;
        }
        return VoicechatCommands.joinGroup(source, server, groupID, password);
    }

    private static int joinGroup(CommandSource source, Server server, UUID groupID, @Nullable String password) throws CommandSyntaxException {
        Group group = server.getGroupManager().getGroup(groupID);
        if (group == null) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("message.voicechat.group_does_not_exist"));
            return 1;
        }
        server.getGroupManager().joinGroup(group, source.func_197035_h(), password);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.join_successful", new Object[]{new StringTextComponent(group.getName()).func_240699_a_(TextFormatting.GRAY)}), false);
        return 1;
    }

    private static int help(CommandDispatcher<CommandSource> dispatcher, CommandContext<CommandSource> commandSource) {
        if (VoicechatCommands.checkNoVoicechat(commandSource)) {
            return 0;
        }
        CommandNode voicechatCommand = dispatcher.getRoot().getChild(VOICECHAT_COMMAND);
        Map map = dispatcher.getSmartUsage(voicechatCommand, commandSource.getSource());
        for (Map.Entry entry : map.entrySet()) {
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new StringTextComponent("/voicechat " + (String)entry.getValue()), false);
        }
        return map.size();
    }

    private static boolean checkNoVoicechat(CommandContext<CommandSource> commandSource) {
        try {
            ServerPlayerEntity player = ((CommandSource)commandSource.getSource()).func_197035_h();
            if (Voicechat.SERVER.isCompatible(player)) {
                return false;
            }
            ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new StringTextComponent(String.format(Voicechat.TRANSLATIONS.voicechatNeededForCommandMessage.get(), CommonCompatibilityManager.INSTANCE.getModName())));
            return true;
        }
        catch (Exception e) {
            ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new StringTextComponent(Voicechat.TRANSLATIONS.playerCommandMessage.get()));
            return true;
        }
    }

    private static boolean checkPermission(CommandSource stack, Permission permission) {
        try {
            return permission.hasPermission(stack.func_197035_h());
        }
        catch (CommandSyntaxException e) {
            return stack.func_197034_c(stack.func_197028_i().func_110455_j());
        }
    }
}

