/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.container.TextureOffset;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AdvancedEntityModel<T extends Entity>
extends SegmentedModel<T> {
    private float movementScale = 1.0f;
    private final Map<String, TextureOffset> modelTextureMap = Maps.newHashMap();

    public void updateDefaultPose() {
        this.getAllParts().forEach(modelRenderer -> {
            AdvancedModelBox advancedRendererModel = modelRenderer;
            advancedRendererModel.updateDefaultPose();
        });
    }

    protected void setTextureOffset(String partName, int x, int y) {
        this.modelTextureMap.put(partName, new TextureOffset(x, y));
    }

    public TextureOffset getTextureOffset(String partName) {
        return this.modelTextureMap.get(partName);
    }

    public void resetToDefaultPose() {
        this.getAllParts().forEach(modelRenderer -> {
            AdvancedModelBox advancedRendererModel = modelRenderer;
            advancedRendererModel.resetToDefaultPose();
        });
    }

    public void faceTarget(float yaw, float pitch, float rotationDivisor, AdvancedModelBox ... boxes) {
        float actualRotationDivisor = rotationDivisor * (float)boxes.length;
        float yawAmount = yaw / 57.295776f / actualRotationDivisor;
        float pitchAmount = pitch / 57.295776f / actualRotationDivisor;
        for (AdvancedModelBox box : boxes) {
            box.field_78796_g += yawAmount;
            box.field_78795_f += pitchAmount;
        }
    }

    public void chainSwing(AdvancedModelBox[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78796_g += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    public void chainWave(AdvancedModelBox[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78795_f += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    public void chainFlap(AdvancedModelBox[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78808_h += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    private float calculateChainRotation(float speed, float degree, float swing, float swingAmount, float offset, int boxIndex) {
        return MathHelper.func_76134_b((float)(swing * (speed * this.movementScale) + offset * (float)boxIndex)) * swingAmount * (degree * this.movementScale);
    }

    private float calculateChainOffset(double rootOffset, AdvancedModelBox ... boxes) {
        return (float)(rootOffset * Math.PI / (double)(2 * boxes.length));
    }

    public float getMovementScale() {
        return this.movementScale;
    }

    public void setMovementScale(float movementScale) {
        this.movementScale = movementScale;
    }

    public void walk(AdvancedModelBox box, float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        box.walk(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(AdvancedModelBox box, float speed, float degree, boolean invert, float offset, float weight, float flap, float flapAmount) {
        box.flap(speed, degree, invert, offset, weight, flap, flapAmount);
    }

    public void swing(AdvancedModelBox box, float speed, float degree, boolean invert, float offset, float weight, float swing, float swingAmount) {
        box.swing(speed, degree, invert, offset, weight, swing, swingAmount);
    }

    public void bob(AdvancedModelBox box, float speed, float degree, boolean bounce, float f, float f1) {
        box.bob(speed, degree, bounce, f, f1);
    }

    public float moveBox(float speed, float degree, boolean bounce, float f, float f1) {
        if (bounce) {
            return -MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)(f * speed)) * f1 * degree));
        }
        return MathHelper.func_76126_a((float)(f * speed)) * f1 * degree - f1 * degree;
    }

    public void setRotateAngle(AdvancedModelBox model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public void rotate(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public void rotateMinus(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x) - model.defaultRotationX, (float)Math.toRadians(y) - model.defaultRotationY, (float)Math.toRadians(z) - model.defaultRotationZ);
    }

    public void progressRotation(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ, float divisor) {
        model.field_78795_f += progress * (rotX - model.defaultRotationX) / divisor;
        model.field_78796_g += progress * (rotY - model.defaultRotationY) / divisor;
        model.field_78808_h += progress * (rotZ - model.defaultRotationZ) / divisor;
    }

    public void progressRotationPrev(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ, float divisor) {
        model.field_78795_f += progress * rotX / divisor;
        model.field_78796_g += progress * rotY / divisor;
        model.field_78808_h += progress * rotZ / divisor;
    }

    public void progressPosition(AdvancedModelBox model, float progress, float x, float y, float z, float divisor) {
        model.field_78800_c += progress * (x - model.defaultPositionX) / divisor;
        model.field_78797_d += progress * (y - model.defaultPositionY) / divisor;
        model.field_78798_e += progress * (z - model.defaultPositionZ) / divisor;
    }

    public void progressPositionPrev(AdvancedModelBox model, float progress, float x, float y, float z, float divisor) {
        model.field_78800_c += progress * x / divisor;
        model.field_78797_d += progress * y / divisor;
        model.field_78798_e += progress * z / divisor;
    }

    public abstract Iterable<AdvancedModelBox> getAllParts();
}

