/*
 * Decompiled with CFR 0.152.
 */
package shaded.ru.turikhay.util.windows.wmi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.commons.lang3.StringUtils;
import shaded.ru.turikhay.util.windows.wmi.Codepage;

public final class WMI {
    static final String CRLF = "\r\n";
    private final String oWMIQuery;
    private final Charset charset;

    public WMI(String oWMIQuery, Charset encoding) {
        this.oWMIQuery = oWMIQuery;
        this.charset = encoding;
    }

    private void writeVbFile(File file, String wmiQueryStr, String wmiCommaSeparatedFieldName) throws IOException {
        try (OutputStreamWriter vbs = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);){
            ((Writer)vbs).append("Dim oWMI : Set oWMI = GetObject(\"winmgmts:").append(this.oWMIQuery).append("\")").append(CRLF);
            ((Writer)vbs).append("Dim classComponent : Set classComponent = oWMI.ExecQuery(\"").append(wmiQueryStr).append("\")").append(CRLF);
            ((Writer)vbs).append("Dim obj, strData").append(CRLF);
            ((Writer)vbs).append("For Each obj in classComponent").append(CRLF);
            for (String fieldName : StringUtils.split(wmiCommaSeparatedFieldName, ',')) {
                ((Writer)vbs).append("  strData = strData & obj.").append(fieldName).append(" & VBCrLf").append(CRLF);
            }
            ((Writer)vbs).append("Next").append(CRLF);
            ((Writer)vbs).append("wscript.echo strData").append(CRLF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getWMIValues(String wmiQueryStr, String fieldName) throws Exception {
        File tmpFile = File.createTempFile("wmi", ".vbs");
        tmpFile.deleteOnExit();
        try {
            this.writeVbFile(tmpFile, wmiQueryStr, fieldName);
            List<String> list = WMI.execute(new String[]{"cmd.exe", "/C", "cscript.exe", tmpFile.getAbsolutePath()}, this.charset);
            return list;
        }
        finally {
            tmpFile.delete();
        }
    }

    private String getEnvVar(String envVarName) throws Exception {
        String varName = "%" + envVarName + "%";
        String envVarValue = WMI.execute(new String[]{"cmd.exe", "/C", "echo " + varName}, this.charset).get(0);
        if (envVarValue.equals(varName)) {
            throw new Exception("Environment variable '" + envVarName + "' does not exist!");
        }
        return envVarValue;
    }

    private void writeStrToFile(String filename, String data) throws Exception {
        FileWriter output = new FileWriter(filename);
        output.write(data);
        output.flush();
        output.close();
    }

    static List<String> execute(String[] cmdArray, Charset charset) throws Exception {
        String line;
        Process process = Runtime.getRuntime().exec(cmdArray);
        BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream(), charset));
        ArrayList<String> output = new ArrayList<String>();
        while ((line = input.readLine()) != null) {
            if (line.contains("Copyright") || line.contains("Microsoft") || line.isEmpty()) continue;
            output.add(line);
        }
        process.destroy();
        return output;
    }

    public static List<String> getAVSoftwareList() throws Exception {
        Charset charset = Codepage.get() == null ? Charset.defaultCharset() : Codepage.get().getCharset();
        WMI wmi = new WMI("{impersonationLevel=impersonate}!\\\\.\\root\\SecurityCenter2", charset);
        return wmi.getWMIValues("Select * from AntiVirusProduct", "displayName");
    }
}

