/*
 * Decompiled with CFR 0.152.
 */
package shaded.de.jangassen.jfa;

import java.util.Arrays;
import java.util.stream.Collectors;
import shaded.de.jangassen.jfa.NamedType;

public class TypeEncoding {
    public static String encode(Class<?> ... classes) {
        return Arrays.stream(classes).map(TypeEncoding::toType).collect(Collectors.joining());
    }

    public static String encode(NamedType ... namedTypes) {
        return Arrays.stream(namedTypes).map(NamedType::getType).map(TypeEncoding::toType).collect(Collectors.joining());
    }

    public static String toType(Class<?> clazz) {
        if (clazz == Void.class || clazz == Void.TYPE) {
            return "v";
        }
        if (Integer.TYPE == clazz) {
            return "i";
        }
        if (Long.TYPE == clazz) {
            return "l";
        }
        if (Object.class.isAssignableFrom(clazz)) {
            return "@";
        }
        if (Boolean.class == clazz || Boolean.TYPE == clazz || Character.TYPE == clazz) {
            return "c";
        }
        return "?";
    }
}

