/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.jthemedetecor;

import com.sun.jna.Callback;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.jthemedetecor.OsThemeDetector;
import shaded.de.jangassen.jfa.foundation.Foundation;
import shaded.de.jangassen.jfa.foundation.ID;
import shaded.org.jetbrains.annotations.NotNull;
import shaded.org.jetbrains.annotations.Nullable;

class MacOSThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(MacOSThemeDetector.class);
    private final Set<Consumer<Boolean>> listeners = Collections.synchronizedSet(new HashSet());
    private final Pattern themeNamePattern = Pattern.compile(".*dark.*", 2);
    private final Callback themeChangedCallback = new Callback(){

        public void callback() {
            MacOSThemeDetector.this.notifyListeners(MacOSThemeDetector.this.isDark());
        }
    };

    MacOSThemeDetector() {
        this.initObserver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initObserver() {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID delegateClass = Foundation.allocateObjcClassPair(Foundation.getObjcClass("NSObject"), "NSColorChangesObserver");
            if (!ID.NIL.equals(delegateClass)) {
                if (!Foundation.addMethod(delegateClass, Foundation.createSelector("handleAppleThemeChanged:"), this.themeChangedCallback, "v@")) {
                    logger.error("Observer method cannot be added");
                }
                Foundation.registerObjcClassPair(delegateClass);
            }
            ID delegate = Foundation.invoke("NSColorChangesObserver", "new", new Object[0]);
            Foundation.invoke(Foundation.invoke("NSDistributedNotificationCenter", "defaultCenter", new Object[0]), "addObserver:selector:name:object:", delegate, Foundation.createSelector("handleAppleThemeChanged:"), Foundation.nsString("AppleInterfaceThemeChangedNotification"), ID.NIL);
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDark() {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID userDefaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            String appleInterfaceStyle = Foundation.toStringViaUTF8(Foundation.invoke(userDefaults, "objectForKey:", Foundation.nsString("AppleInterfaceStyle")));
            boolean bl = this.isDarkTheme(appleInterfaceStyle);
            return bl;
        }
        catch (RuntimeException e) {
            logger.error("Couldn't execute theme name query with the Os", e);
        }
        finally {
            pool.drain();
        }
        return false;
    }

    private boolean isDarkTheme(String themeName) {
        return this.themeNamePattern.matcher(themeName).matches();
    }

    @Override
    public void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        this.listeners.add(darkThemeListener);
    }

    @Override
    public void removeListener(@Nullable Consumer<Boolean> darkThemeListener) {
        this.listeners.remove(darkThemeListener);
    }

    private void notifyListeners(boolean isDark) {
        this.listeners.forEach(listener -> listener.accept(isDark));
    }
}

