/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.jthemedetecor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.jthemedetecor.OsThemeDetector;
import shaded.org.jetbrains.annotations.NotNull;
import shaded.org.jetbrains.annotations.Nullable;

class GnomeThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(GnomeThemeDetector.class);
    private static final String MONITORING_CMD = "gsettings monitor org.gnome.desktop.interface gtk-theme";
    private static final String GET_CMD = "gsettings get org.gnome.desktop.interface gtk-theme";
    private final Set<Consumer<Boolean>> listeners = Collections.synchronizedSet(new HashSet());
    private final Pattern darkThemeNamePattern = Pattern.compile(".*dark.*", 2);
    private DetectorThread detectorThread;

    GnomeThemeDetector() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDark() {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(GET_CMD);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String readLine = reader.readLine();
                if (readLine == null) return false;
                boolean bl = this.isDarkTheme(readLine);
                return bl;
            }
        }
        catch (IOException e) {
            logger.error("Couldn't detect Linux OS theme", e);
        }
        return false;
    }

    private boolean isDarkTheme(String gtkTheme) {
        return this.darkThemeNamePattern.matcher(gtkTheme).matches();
    }

    @Override
    public synchronized void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        boolean threadInterrupted;
        Objects.requireNonNull(darkThemeListener);
        boolean listenerAdded = this.listeners.add(darkThemeListener);
        boolean singleListener = listenerAdded && this.listeners.size() == 1;
        boolean bl = threadInterrupted = this.detectorThread != null && this.detectorThread.isInterrupted();
        if (singleListener || threadInterrupted) {
            this.detectorThread = new DetectorThread(this);
            this.detectorThread.start();
        }
    }

    @Override
    public synchronized void removeListener(@Nullable Consumer<Boolean> darkThemeListener) {
        this.listeners.remove(darkThemeListener);
        if (this.listeners.isEmpty()) {
            this.detectorThread.interrupt();
            this.detectorThread = null;
        }
    }

    private static final class DetectorThread
    extends Thread {
        private final GnomeThemeDetector detector;
        private boolean lastValue;

        DetectorThread(@NotNull GnomeThemeDetector detector) {
            this.detector = detector;
            this.lastValue = detector.isDark();
            this.setName("GTK Theme Detector Thread");
            this.setDaemon(true);
            this.setPriority(4);
        }

        @Override
        public void run() {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process monitoringProcess = runtime.exec(GnomeThemeDetector.MONITORING_CMD);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(monitoringProcess.getInputStream()));){
                    while (!this.isInterrupted()) {
                        String readLine = reader.readLine();
                        String[] keyValue = readLine.split("\\s");
                        String value = keyValue[1];
                        boolean currentDetection = this.detector.isDarkTheme(value);
                        logger.debug("Theme changed detection, dark: {}", (Object)currentDetection);
                        if (currentDetection == this.lastValue) continue;
                        this.lastValue = currentDetection;
                        for (Consumer<Boolean> listener : this.detector.listeners) {
                            try {
                                listener.accept(currentDetection);
                            }
                            catch (RuntimeException e) {
                                logger.error("Caught exception during listener notifying ", e);
                            }
                        }
                    }
                    logger.debug("ThemeDetectorThread has been interrupted!");
                    if (monitoringProcess.isAlive()) {
                        monitoringProcess.destroy();
                        logger.debug("Monitoring process has been destroyed!");
                    }
                }
            }
            catch (IOException e) {
                logger.error("Couldn't start monitoring process ", e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                logger.error("Couldn't parse command line output", e);
            }
        }
    }
}

