/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven.connection;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.getsentry.raven.connection.Connection;
import shaded.com.getsentry.raven.connection.ConnectionException;
import shaded.com.getsentry.raven.connection.EventSendFailureCallback;
import shaded.com.getsentry.raven.connection.LockdownManager;
import shaded.com.getsentry.raven.connection.LockedDownException;
import shaded.com.getsentry.raven.environment.RavenEnvironment;
import shaded.com.getsentry.raven.event.Event;

public abstract class AbstractConnection
implements Connection {
    public static final String SENTRY_PROTOCOL_VERSION = "6";
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnection.class);
    private final String authHeader;
    private Set<EventSendFailureCallback> eventSendFailureCallbacks;
    private LockdownManager lockdownManager = new LockdownManager();

    protected AbstractConnection(String publicKey, String secretKey) {
        this.eventSendFailureCallbacks = new HashSet<EventSendFailureCallback>();
        this.authHeader = "Sentry sentry_version=6,sentry_client=" + RavenEnvironment.getRavenName() + "," + "sentry_key=" + publicKey + "," + "sentry_secret=" + secretKey;
    }

    protected String getAuthHeader() {
        return this.authHeader;
    }

    @Override
    public final void send(Event event) throws ConnectionException {
        try {
            if (this.lockdownManager.isLockedDown()) {
                throw new LockedDownException("Dropping an Event due to lockdown: " + event);
            }
            this.doSend(event);
            this.lockdownManager.resetState();
        }
        catch (ConnectionException e) {
            for (EventSendFailureCallback eventSendFailureCallback : this.eventSendFailureCallbacks) {
                try {
                    eventSendFailureCallback.onFailure(event, e);
                }
                catch (Exception exc) {
                    logger.warn("An exception occurred while running an EventSendFailureCallback: " + eventSendFailureCallback.getClass().getName(), exc);
                }
            }
            logger.warn("An exception due to the connection occurred, a lockdown will be initiated.", e);
            this.lockdownManager.setState(e);
            throw e;
        }
    }

    protected abstract void doSend(Event var1) throws ConnectionException;

    @Deprecated
    public void setMaxWaitingTime(long maxWaitingTime) {
        this.lockdownManager.setMaxLockdownTime(maxWaitingTime);
    }

    @Deprecated
    public void setBaseWaitingTime(long baseWaitingTime) {
        this.lockdownManager.setBaseLockdownTime(baseWaitingTime);
    }

    @Override
    public void addEventSendFailureCallback(EventSendFailureCallback eventSendFailureCallback) {
        this.eventSendFailureCallbacks.add(eventSendFailureCallback);
    }
}

