/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.getsentry.raven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import shaded.com.getsentry.raven.event.Breadcrumb;
import shaded.com.getsentry.raven.event.User;
import shaded.com.getsentry.raven.util.CircularFifoQueue;

public class RavenContext
implements AutoCloseable {
    private static ThreadLocal<IdentityHashMap<RavenContext, RavenContext>> activeContexts = new ThreadLocal<IdentityHashMap<RavenContext, RavenContext>>(){

        @Override
        protected IdentityHashMap<RavenContext, RavenContext> initialValue() {
            return new IdentityHashMap<RavenContext, RavenContext>();
        }
    };
    private static final int DEFAULT_BREADCRUMB_LIMIT = 100;
    private UUID lastEventId;
    private CircularFifoQueue<Breadcrumb> breadcrumbs;
    private User user;

    public RavenContext() {
        this(100);
    }

    public RavenContext(int breadcrumbLimit) {
        this.breadcrumbs = new CircularFifoQueue(breadcrumbLimit);
    }

    public void activate() {
        activeContexts.get().put(this, this);
    }

    public void deactivate() {
        activeContexts.get().remove(this);
    }

    public void clear() {
        this.breadcrumbs.clear();
        this.lastEventId = null;
        this.user = null;
    }

    @Override
    public void close() {
        this.deactivate();
    }

    public static List<RavenContext> getActiveContexts() {
        Collection<RavenContext> ravenContexts = activeContexts.get().values();
        ArrayList<RavenContext> list = new ArrayList<RavenContext>(ravenContexts.size());
        list.addAll(ravenContexts);
        return list;
    }

    public Iterator<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs.iterator();
    }

    public void recordBreadcrumb(Breadcrumb breadcrumb) {
        this.breadcrumbs.add(breadcrumb);
    }

    public void setLastEventId(UUID id) {
        this.lastEventId = id;
    }

    public UUID getLastEventId() {
        return this.lastEventId;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void clearUser() {
        this.setUser(null);
    }

    public User getUser() {
        return this.user;
    }
}

