/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.portals;

import java.util.ArrayList;
import java.util.Locale;
import ru.turikhay.tlauncher.portals.JVMPortal;
import ru.turikhay.tlauncher.portals.NoopPortal;
import ru.turikhay.tlauncher.portals.Portal;
import ru.turikhay.tlauncher.portals.PortalCombiner;
import ru.turikhay.tlauncher.portals.XDGPortal;
import ru.turikhay.util.JavaVersion;

public class Portals {
    private static final Portal PORTAL;

    private Portals() {
    }

    public static Portal getPortal() {
        return PORTAL;
    }

    private static boolean isLinux() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        return os.toLowerCase(Locale.ROOT).contains("linux");
    }

    static {
        ArrayList<Portal> portals = new ArrayList<Portal>();
        if (JavaVersion.getCurrent().getMajor() >= 11 && Portals.isLinux()) {
            try {
                XDGPortal.tryToCreate().ifPresent(portals::add);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        JVMPortal.tryToCreate().ifPresent(portals::add);
        switch (portals.size()) {
            case 0: {
                PORTAL = new NoopPortal();
                break;
            }
            case 1: {
                PORTAL = (Portal)portals.get(0);
                break;
            }
            default: {
                PORTAL = new PortalCombiner(portals);
            }
        }
    }
}

