/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.portals;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.turikhay.tlauncher.portals.Portal;
import ru.turikhay.util.JavaVersion;
import shaded.com.jthemedetecor.OsThemeDetector;

public class JVMPortal
implements Portal {
    private static final Logger LOGGER = LoggerFactory.getLogger(JVMPortal.class);
    private final Desktop desktop;

    private JVMPortal(Desktop desktop) {
        this.desktop = desktop;
    }

    @Override
    public boolean openURI(URI uri) {
        try {
            this.desktop.browse(uri);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean openFile(Path path) {
        try {
            this.desktop.open(path.toFile());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean openDirectory(Path path) {
        return this.openFile(path.getParent());
    }

    @Override
    public Portal.ColorScheme getColorScheme() {
        if (JavaVersion.getCurrent().getMajor() >= 11) {
            OsThemeDetector detector = OsThemeDetector.getDetector();
            return detector.isDark() ? Portal.ColorScheme.PREFER_DARK : Portal.ColorScheme.PREFER_LIGHT;
        }
        return Portal.ColorScheme.NO_PREFERENCE;
    }

    public static Optional<JVMPortal> tryToCreate() {
        if (!Desktop.isDesktopSupported()) {
            LOGGER.warn("Desktop API is not supported");
            return Optional.empty();
        }
        return Optional.of(new JVMPortal(Desktop.getDesktop()));
    }
}

