/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.dbus.transport.junixsocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.spi.message.IMessageWriter;
import org.freedesktop.dbus.utils.Hexdump;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.Hack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnixSocketMessageWriter
implements IMessageWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AFUNIXSocketChannel socket;

    public JUnixSocketMessageWriter(AFUNIXSocketChannel socket) {
        this.socket = socket;
    }

    @Override
    public void close() throws IOException {
        if (this.socket.isOpen()) {
            this.logger.debug("Closing Message Writer");
            this.socket.close();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.socket.isOpen();
    }

    @Override
    public void writeMessage(Message msg) throws IOException {
        this.logger.debug("<= {}", (Object)msg);
        if (msg == null) {
            return;
        }
        byte[][] wireData = msg.getWireData();
        if (wireData == null) {
            this.logger.warn("Message {} wire-data was null!", (Object)msg);
            return;
        }
        List<FileDescriptor> fdsList = msg.getFiledescriptors();
        if (!fdsList.isEmpty()) {
            try {
                java.io.FileDescriptor[] fds = new java.io.FileDescriptor[fdsList.size()];
                for (int i = 0; i < fdsList.size(); ++i) {
                    fds[i] = Hack.createFileDescriptor(fdsList.get(i).getIntFileDescriptor());
                }
                this.socket.setOutboundFileDescriptors(fds);
            }
            catch (IOException e) {
                this.logger.error("Unable to extract FileDescriptor", e);
                return;
            }
        }
        for (byte[] bytes : wireData) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("{}", (Object)(bytes == null ? "(buffer was null)" : Hexdump.format(bytes)));
            }
            if (bytes == null) break;
            this.socket.write(ByteBuffer.wrap(bytes));
        }
        if (!fdsList.isEmpty()) {
            this.socket.setOutboundFileDescriptors(null);
        }
        this.logger.trace("Message sent: {}", (Object)msg);
    }
}

