/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.dbus.transport.junixsocket;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageProtocolVersionException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MessageFactory;
import org.freedesktop.dbus.spi.message.IMessageReader;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.Hack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnixSocketMessageReader
implements IMessageReader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AFUNIXSocketChannel socket;
    private final int[] len = new int[4];
    private final ByteBuffer buf = ByteBuffer.allocateDirect(12);
    private final ByteBuffer tbuf = ByteBuffer.allocateDirect(4);
    private ByteBuffer header = null;
    private ByteBuffer body = null;

    public JUnixSocketMessageReader(AFUNIXSocketChannel socket) {
        this.socket = socket;
    }

    @Override
    public void close() throws IOException {
        if (this.socket.isOpen()) {
            this.logger.debug("Closing Message Writer");
            this.socket.close();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.socket.isOpen();
    }

    @Override
    public Message readMessage() throws IOException, DBusException {
        int headerlen;
        ByteOrder byteOrder;
        if (this.len[0] < 12) {
            try {
                int rv = this.socket.read(this.buf);
                if (rv < 0) {
                    throw new EOFException("(1) Underlying transport returned " + rv);
                }
                this.len[0] = this.len[0] + rv;
            }
            catch (SocketTimeoutException e) {
                return null;
            }
        }
        if (this.len[0] == 0) {
            return null;
        }
        if (this.len[0] < 12) {
            this.logger.trace("Only got {} of 12 bytes of header", (Object)this.len[0]);
            return null;
        }
        this.buf.flip();
        byte protoVer = this.buf.get(3);
        if (protoVer > 1) {
            throw new MessageProtocolVersionException(String.format("Protocol version %s is unsupported", protoVer));
        }
        switch (this.buf.get(0)) {
            case 66: {
                byteOrder = ByteOrder.BIG_ENDIAN;
                break;
            }
            case 108: {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported endian: %s", Character.valueOf((char)this.buf.get(0))));
            }
        }
        this.buf.order(byteOrder);
        this.tbuf.order(byteOrder);
        if (this.len[1] < 4) {
            try {
                int rv = this.socket.read(this.tbuf);
                if (rv < 0) {
                    throw new EOFException("(2) Underlying transport returned " + rv);
                }
                this.len[1] = this.len[1] + rv;
            }
            catch (SocketTimeoutException e) {
                return null;
            }
        }
        if (this.len[1] < 4) {
            this.logger.trace("Only got {} of 4 bytes of header", (Object)this.len[1]);
            return null;
        }
        this.tbuf.flip();
        if (this.header == null) {
            headerlen = this.tbuf.getInt(0);
            int modlen = headerlen & 7;
            if (modlen != 0) {
                headerlen += 8 - modlen;
            }
            this.header = ByteBuffer.allocateDirect(headerlen + 8).put(this.tbuf).position(8);
            this.len[2] = 0;
        } else {
            headerlen = this.header.capacity() - 8;
        }
        if (this.len[2] < headerlen) {
            try {
                int rv = this.socket.read(this.header);
                if (rv < 0) {
                    throw new EOFException("(3) Underlying transport returned " + rv);
                }
                this.len[2] = this.len[2] + rv;
            }
            catch (SocketTimeoutException e) {
                return null;
            }
        }
        if (this.len[2] < headerlen) {
            this.logger.trace("Only got {} of {} bytes of header", (Object)this.len[2], (Object)headerlen);
            return null;
        }
        this.header.flip();
        byte type = this.buf.get(1);
        if (this.body == null) {
            this.body = ByteBuffer.allocateDirect(this.buf.getInt(4));
            this.len[3] = 0;
        }
        if (this.len[3] < this.body.capacity()) {
            try {
                int rv = this.socket.read(this.body);
                if (rv < 0) {
                    throw new EOFException("(4) Underlying transport returned " + rv);
                }
                this.len[3] = this.len[3] + rv;
            }
            catch (SocketTimeoutException e) {
                return null;
            }
        }
        if (this.len[3] < this.body.capacity()) {
            this.logger.trace("Only got {} of {} bytes of body", (Object)this.len[3], (Object)this.body.capacity());
            return null;
        }
        this.body.flip();
        try {
            ArrayList<FileDescriptor> fds;
            java.io.FileDescriptor[] receivedFileDescriptors = this.socket.getReceivedFileDescriptors();
            if (receivedFileDescriptors.length == 0) {
                fds = null;
            } else {
                fds = new ArrayList<FileDescriptor>(receivedFileDescriptors.length);
                for (int i = 0; i < receivedFileDescriptors.length; ++i) {
                    fds.set(i, new FileDescriptor(Hack.getFileDescriptor(receivedFileDescriptors[i])));
                }
            }
            if (fds != null) {
                this.logger.debug("=> {}", (Object)fds);
            }
            Message message = MessageFactory.createMessage(type, JUnixSocketMessageReader.remaining(this.buf), JUnixSocketMessageReader.remaining(this.header), JUnixSocketMessageReader.remaining(this.body), fds);
            return message;
        }
        catch (RuntimeException | DBusException e) {
            this.logger.warn("Exception while creating message.", e);
            throw e;
        }
        finally {
            this.tbuf.rewind();
            this.buf.rewind();
            Arrays.fill(this.len, 0);
            this.body = null;
            this.header = null;
        }
    }

    private static byte[] remaining(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }
}

