/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui;

import java.util.Objects;
import ru.turikhay.tlauncher.bootstrap.exception.FatalExceptionType;
import ru.turikhay.tlauncher.bootstrap.task.Task;
import ru.turikhay.tlauncher.bootstrap.task.TaskListener;
import ru.turikhay.tlauncher.bootstrap.ui.IInterface;
import ru.turikhay.tlauncher.bootstrap.ui.UserInterface;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.com.google.gson.Gson;
import shaded.com.google.gson.GsonBuilder;
import shaded.org.apache.commons.lang3.exception.ExceptionUtils;

public final class HeadlessInterface
implements IInterface {
    private static Gson gson;
    private final TaskListener<Object> listener = new TaskListener<Object>(){

        @Override
        public void onTaskStarted(Task<?> task) {
            HeadlessInterface.printEvent(new TaskEvent(task));
        }

        @Override
        public void onTaskUpdated(Task<?> task, double percentage) {
            HeadlessInterface.printEvent(new TaskEvent(task));
            if (percentage == 1.0) {
                this.onTaskSucceeded(task);
            }
        }

        @Override
        public void onTaskSucceeded(Task<?> task) {
            HeadlessInterface.printEvent(new TaskEvent(task));
            HeadlessInterface.this.dispose();
        }
    };
    private Task<?> bindingTask;

    @Override
    public void bindToTask(Task<?> task) {
        if (this.bindingTask != null && this.bindingTask.isExecuting()) {
            throw new IllegalStateException();
        }
        this.bindingTask = task;
        if (this.bindingTask != null) {
            this.bindingTask.addListener(this.listener);
        }
    }

    @Override
    public void dispose() {
        HeadlessInterface.printEvent(new DisposeEvent());
    }

    private static void printEvent(Event event) {
        U.log("[Hi]", HeadlessInterface.gson().toJson(Objects.requireNonNull(event, "event")));
    }

    private static Gson gson() {
        if (gson == null) {
            gson = new GsonBuilder().create();
        }
        return gson;
    }

    private static void printAlert(EventAlertType eventType, String message, Object textarea) {
        HeadlessInterface.printEvent(new AlertEvent(eventType, message, textarea));
    }

    static void printError(String message, Object textarea) {
        HeadlessInterface.printAlert(EventAlertType.ERROR, message, textarea);
    }

    static void printWarning(String message, Object textarea) {
        HeadlessInterface.printAlert(EventAlertType.WARNING, message, textarea);
    }

    public static void printVersion(String bootstrapVersion, String launcherVersion) {
        HeadlessInterface.printEvent(new VersionEvent(bootstrapVersion, launcherVersion));
    }

    static void printFatalException(FatalExceptionType type) {
        HeadlessInterface.printEvent(new FatalExceptionEvent(type));
    }

    private static class Event {
        public final EventType type;

        Event(EventType type) {
            this.type = Objects.requireNonNull(type, "type");
        }
    }

    private static class DisposeEvent
    extends Event {
        public DisposeEvent() {
            super(EventType.DISPOSE);
        }
    }

    private static class AlertEvent
    extends Event {
        public final EventAlertType alertType;
        public final String message;
        public final String appendMessage;

        public AlertEvent(EventAlertType type, String message, Object textarea) {
            super(EventType.ALERT);
            this.alertType = type;
            this.message = message;
            this.appendMessage = textarea instanceof Throwable ? ExceptionUtils.getStackTrace((Throwable)textarea) : (textarea == null ? null : String.valueOf(textarea));
        }
    }

    private static enum EventAlertType {
        WARNING,
        ERROR;

    }

    private static class VersionEvent
    extends Event {
        public final String bootstrapVersion;
        public final String launcherVersion;

        VersionEvent(String bootstrapVersion, String launcherVersion) {
            super(EventType.VERSION);
            this.bootstrapVersion = Objects.requireNonNull(bootstrapVersion, "bootstrapVersion");
            this.launcherVersion = launcherVersion;
        }
    }

    private static class FatalExceptionEvent
    extends Event {
        public final FatalExceptionType exceptionType;

        FatalExceptionEvent(FatalExceptionType exceptionType) {
            super(EventType.FATAL_EXCEPTION);
            this.exceptionType = exceptionType;
        }
    }

    private static class TaskEvent
    extends Event {
        public final String taskName;
        public final String localizedTaskName;
        public final double progress;

        TaskEvent(Task<?> task) {
            super(EventType.TASK);
            Task<?> childTask = UserInterface.getChildTask(task, 2);
            this.taskName = childTask.getName();
            this.localizedTaskName = UserInterface.getLocalizedTaskName(childTask);
            this.progress = task.getProgress();
        }
    }

    private static enum EventType {
        VERSION,
        TASK,
        ALERT,
        FATAL_EXCEPTION,
        DISPOSE;

    }
}

