/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui;

import java.util.ResourceBundle;
import ru.turikhay.tlauncher.bootstrap.exception.FatalExceptionType;
import ru.turikhay.tlauncher.bootstrap.ui.PastaAction;
import ru.turikhay.tlauncher.bootstrap.ui.SaveLogsAction;
import ru.turikhay.tlauncher.bootstrap.ui.UserInterface;
import ru.turikhay.tlauncher.bootstrap.ui.message.BiButtonMessage;
import ru.turikhay.tlauncher.bootstrap.ui.message.Button;
import ru.turikhay.tlauncher.bootstrap.ui.message.Message;
import ru.turikhay.tlauncher.bootstrap.ui.message.MessageHost;
import ru.turikhay.tlauncher.bootstrap.ui.message.TextMessage;

final class FatalExceptionHandler {
    private final ResourceBundle b = UserInterface.getResourceBundle();
    private final FatalExceptionType exceptionType;
    private final MessageHost host;

    private FatalExceptionHandler(FatalExceptionType exceptionType) {
        this.exceptionType = exceptionType;
        this.host = new MessageHost();
    }

    void showMessage() {
        this.host.setTitle(this.b.getString("fatal.title"));
        this.host.showMessage(this.initialErrorMessage());
    }

    private Message initialErrorMessage() {
        String text = this.getInitialText();
        return new BiButtonMessage(text, this.contactButton(), this.createCloseButton());
    }

    private Button contactButton() {
        boolean canUsePasta = this.canUsePasta();
        return new Button(this.b.getString("fatal.buttons." + (canUsePasta ? "send_logs" : "contact")), canUsePasta ? this.pastaAction() : this::contactDirectly);
    }

    private Runnable pastaAction() {
        return new PastaAction(this.host);
    }

    private void contactDirectly() {
        this.host.showMessage(new BiButtonMessage(this.b.getString("contact-directly.save-logs"), new Button(this.b.getString("contact-directly.save-logs.yes"), () -> new SaveLogsAction(this.host).run()), new Button(this.b.getString("contact-directly.save-logs.no"), this::showContacts)));
    }

    private void showContacts() {
        this.host.showMessage(new TextMessage(this.b.getString("contact-directly") + "<br/>" + this.b.getString("contacts")));
    }

    private Button createCloseButton() {
        return new Button(this.b.getString("fatal.buttons.close"), this.host::close);
    }

    private String getInitialText() {
        boolean isUnknown = false;
        switch (this.exceptionType) {
            case FILE_LOCKED: 
            case UNKNOWN: {
                isUnknown = true;
            }
        }
        FatalExceptionType effective = isUnknown ? FatalExceptionType.UNKNOWN : this.exceptionType;
        return this.b.getString("fatal.type." + effective.nameLowerCase()) + "<br/><br/>" + this.b.getString("fatal.bottom." + (this.canUsePasta() ? "pasta" : "contact_directly"));
    }

    private boolean canUsePasta() {
        boolean canUsePasta = true;
        switch (this.exceptionType) {
            case INTERNET_CONNECTIVITY_BLOCKED: 
            case CORRUPTED_INSTALLATION: 
            case INTERNET_CONNECTIVITY: {
                canUsePasta = false;
            }
        }
        return canUsePasta;
    }

    void waitForClose() {
        try {
            this.host.waitForClose();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static void handle(FatalExceptionType type) {
        FatalExceptionHandler handler = new FatalExceptionHandler(type);
        handler.showMessage();
        handler.waitForClose();
    }
}

