/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.net.URL;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import ru.turikhay.tlauncher.bootstrap.util.OS;

class EditorPane
extends JEditorPane {
    private final String textColor;

    public EditorPane(Font font) {
        Color color = new JLabel().getForeground();
        this.textColor = String.format(Locale.ROOT, "#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        if (font != null) {
            this.setFont(font);
        } else {
            font = this.getFont();
        }
        StyleSheet css = new StyleSheet();
        css.importStyleSheet(this.getClass().getResource("styles.css"));
        css.addRule("body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: " + this.textColor + "; } a { color: " + this.textColor + "; text-decoration: underline; }");
        HTMLEditorKit html = new HTMLEditorKit();
        html.setStyleSheet(css);
        this.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setEditorKit(html);
        this.setEditable(false);
        this.setOpaque(false);
        this.addHyperlinkListener(e -> {
            URL url;
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && (url = e.getURL()) != null) {
                OS.openUrl(url);
            }
        });
    }

    private EditorPane() {
        this(new JLabel().getFont());
    }

    public EditorPane(String type, String text) {
        this();
        this.setContentType(type);
        this.setText(text);
    }
}

