/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import ru.turikhay.tlauncher.bootstrap.transport.ChecksumStream;
import ru.turikhay.tlauncher.bootstrap.transport.InvalidStreamSignatureException;
import ru.turikhay.tlauncher.bootstrap.transport.StreamNotSignedException;
import ru.turikhay.tlauncher.bootstrap.util.Sha256Sign;
import ru.turikhay.tlauncher.bootstrap.util.U;
import shaded.org.apache.commons.io.IOUtils;

public class SignedStream
extends ChecksumStream {
    static final PublicKey PUBLIC_KEY;
    byte[] signedChecksum;

    public SignedStream(InputStream stream) {
        super(stream);
    }

    @Override
    public int read() throws IOException {
        this.readSignature();
        int r = super.read();
        if (r == -1) {
            this.validateSignature();
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.readSignature();
        int r = super.read(b);
        if (r == -1) {
            this.validateSignature();
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readSignature();
        int r = super.read(b, off, len);
        if (r == -1) {
            this.validateSignature();
        }
        return r;
    }

    boolean readSignature() throws IOException {
        if (this.signedChecksum != null) {
            return false;
        }
        byte[] signature = new byte[256];
        int signatureLength = IOUtils.read(this.in, signature);
        if (signatureLength != 256) {
            throw new StreamNotSignedException("invalid signedChecksum length; expected: 256, got: " + signatureLength);
        }
        this.signedChecksum = signature;
        return true;
    }

    public void validateSignature() throws IOException {
        if (this.signedChecksum == null) {
            throw new StreamNotSignedException("signedChecksum not read yet");
        }
        byte[] digest = this.digest();
        if (digest == null) {
            throw new IOException("calc is not calculated");
        }
        byte[] perCharChecksum = Sha256Sign.toString(digest).getBytes(StandardCharsets.UTF_8);
        if (!SignedStream.verify(perCharChecksum, this.signedChecksum)) {
            throw new InvalidStreamSignatureException();
        }
    }

    static boolean verify(byte[] data, byte[] signature) {
        try {
            Signature signatureRef = Signature.getInstance("SHA1withRSA");
            signatureRef.initVerify(PUBLIC_KEY);
            signatureRef.update(data);
            return signatureRef.verify(signature);
        }
        catch (SignatureException sign) {
            U.log("could not verify signature", sign);
            return false;
        }
        catch (Exception e) {
            throw new Error("verification error", e);
        }
    }

    static {
        PublicKey publicKey;
        try {
            URL url = SignedStream.class.getResource("/public.der");
            Objects.requireNonNull(url, "could not find public.der");
            X509EncodedKeySpec e = new X509EncodedKeySpec(IOUtils.toByteArray(url));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(e);
        }
        catch (Exception e) {
            throw new Error("no public key?", e);
        }
        PUBLIC_KEY = publicKey;
    }
}

