/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.transport;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Objects;
import ru.turikhay.tlauncher.bootstrap.util.Sha256Sign;
import ru.turikhay.tlauncher.bootstrap.util.WeakObjectPool;

public class ChecksumStream
extends FilterInputStream {
    private final WeakObjectPool.ObjectRef<MessageDigest> ref = Sha256Sign.getDigest();
    private MessageDigest digest = Objects.requireNonNull(this.ref.get(), "calc ref");
    private byte[] byteDigest;

    public ChecksumStream(InputStream stream) {
        super(stream);
    }

    public byte[] digest() {
        return this.digest != null ? this.digest.digest() : (byte[])(this.byteDigest != null ? (byte[])this.byteDigest.clone() : null);
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        if (read != -1) {
            this.digest.update((byte)read);
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int readLen = this.in.read(b);
        if (readLen != -1) {
            this.digest.update(b, 0, readLen);
        }
        return readLen;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readLen = this.in.read(b, off, len);
        if (readLen != -1) {
            this.digest.update(b, off, readLen);
        }
        return readLen;
    }

    @Override
    public void close() throws IOException {
        this.byteDigest = this.digest.digest();
        this.digest = null;
        this.ref.free();
        super.close();
    }
}

