/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.bootstrap.task;

import ru.turikhay.tlauncher.bootstrap.task.Task;

public class TaskException
extends Exception {
    TaskException(Task<?> task) {
        super(TaskException.getTaskName(task, null));
    }

    TaskException(Task<?> task, Throwable cause) {
        super(TaskException.getTaskName(task, cause), cause);
    }

    private static String getTaskName(Task<?> task, Throwable cause) {
        if (task == null) {
            return cause == null ? "(null task, null cause)" : "(null task)";
        }
        Task<?> currentTask = TaskException.getHighestTask(task);
        StringBuilder b = new StringBuilder();
        if (cause != null) {
            b.append(cause).append("\n");
        }
        b.append(currentTask.toString());
        while (currentTask.bindingTask != null) {
            currentTask = currentTask.bindingTask;
            b.append(" -> ").append(currentTask);
        }
        return b.toString();
    }

    private static Task<?> getHighestTask(Task<?> task) {
        while (task.boundTask != null) {
            task = task.boundTask;
        }
        return task;
    }
}

